/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.Generator;
import org.databene.benerator.composite.ComponentBuilder;
import org.databene.benerator.composite.ComponentTypeConverter;
import org.databene.benerator.composite.ConfiguredEntityGenerator;
import org.databene.benerator.composite.EntityGenerator;
import org.databene.benerator.composite.SimpleTypeEntityGenerator;
import org.databene.benerator.engine.BeneratorContext;
import org.databene.benerator.factory.ComponentBuilderFactory;
import org.databene.benerator.factory.DescriptorUtil;
import org.databene.benerator.factory.InstanceGeneratorFactory;
import org.databene.benerator.factory.SimpleTypeGeneratorFactory;
import org.databene.benerator.factory.TypeGeneratorFactory;
import org.databene.benerator.parser.BasicParser;
import org.databene.benerator.sample.SequencedSampleGenerator;
import org.databene.benerator.sample.WeightedSampleGenerator;
import org.databene.benerator.util.GeneratorUtil;
import org.databene.benerator.wrapper.AlternativeGenerator;
import org.databene.benerator.wrapper.ConvertingGenerator;
import org.databene.benerator.wrapper.IteratingGenerator;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.Converter;
import org.databene.commons.IOUtil;
import org.databene.commons.bean.ClassProvider;
import org.databene.commons.converter.ConverterChain;
import org.databene.commons.converter.ToStringConverter;
import org.databene.dataset.DatasetFactory;
import org.databene.document.flat.FlatFileColumnDescriptor;
import org.databene.document.flat.FlatFileUtil;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.Entity;
import org.databene.model.data.EntitySource;
import org.databene.model.data.InstanceDescriptor;
import org.databene.model.data.Mode;
import org.databene.model.data.SimpleTypeDescriptor;
import org.databene.model.data.TypeDescriptor;
import org.databene.model.function.Distribution;
import org.databene.model.function.IndividualWeight;
import org.databene.model.function.Sequence;
import org.databene.model.function.WeightFunction;
import org.databene.model.storage.StorageSystem;
import org.databene.platform.csv.CSVEntitySource;
import org.databene.platform.dbunit.DbUnitEntitySource;
import org.databene.platform.flat.FlatFileEntitySource;
import org.databene.platform.xls.XLSEntitySource;
import org.databene.script.ScriptConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexTypeGeneratorFactory {
    private static final Log logger = LogFactory.getLog(ComplexTypeGeneratorFactory.class);

    private ComplexTypeGeneratorFactory() {
    }

    public static Generator<Entity> createComplexTypeGenerator(ComplexTypeDescriptor type, boolean unique, BeneratorContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("create(" + type.getName() + ")"));
        }
        Generator<? extends Object> generator = null;
        generator = DescriptorUtil.getGeneratorByName(type, context);
        if (generator == null) {
            generator = ComplexTypeGeneratorFactory.createSourceGenerator(type, context);
        }
        generator = generator == null ? ComplexTypeGeneratorFactory.createSyntheticEntityGenerator(type, unique, context) : ComplexTypeGeneratorFactory.createMutatingEntityGenerator(type, context, generator);
        generator = TypeGeneratorFactory.wrapWithPostprocessors(generator, type, context);
        generator = ComplexTypeGeneratorFactory.wrapGeneratorWithVariables(type, context, generator);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created " + generator));
        }
        return generator;
    }

    private static Generator<Entity> wrapGeneratorWithVariables(ComplexTypeDescriptor type, BeneratorContext context, Generator<Entity> generator) {
        Collection<InstanceDescriptor> variables = ComplexTypeGeneratorFactory.variablesOfThisAndParents(type);
        HashMap<String, Generator<? extends Object>> varGens = new HashMap<String, Generator<? extends Object>>();
        for (InstanceDescriptor variable : variables) {
            Generator<? extends Object> varGen = InstanceGeneratorFactory.createInstanceGenerator(variable, context);
            varGens.put(variable.getName(), varGen);
        }
        return new ConfiguredEntityGenerator(generator, varGens, (Context)context);
    }

    private static Collection<InstanceDescriptor> variablesOfThisAndParents(TypeDescriptor type) {
        ArrayList<InstanceDescriptor> variables = new ArrayList<InstanceDescriptor>();
        while (type instanceof ComplexTypeDescriptor) {
            variables.addAll(((ComplexTypeDescriptor)type).getVariables());
            type = type.getParent();
        }
        return variables;
    }

    private static Generator<Entity> createSourceGenerator(ComplexTypeDescriptor descriptor, BeneratorContext context) {
        Distribution distribution;
        String sourceName = descriptor.getSource();
        if (sourceName == null) {
            return null;
        }
        Generator<Entity> generator = null;
        Object contextSourceObject = context.get(sourceName);
        if (contextSourceObject != null) {
            generator = ComplexTypeGeneratorFactory.createSourceGeneratorFromObject(descriptor, context, generator, contextSourceObject);
        } else {
            String lcSourceName = sourceName.toLowerCase();
            if (lcSourceName.endsWith(".xml")) {
                String uri = IOUtil.resolveLocalUri((String)sourceName, (String)context.getContextUri());
                generator = new IteratingGenerator<Entity>(new DbUnitEntitySource(uri, (Context)context));
            } else if (lcSourceName.endsWith(".csv")) {
                String uri = IOUtil.resolveLocalUri((String)sourceName, (String)context.getContextUri());
                generator = ComplexTypeGeneratorFactory.createCSVSourceGenerator(descriptor, context, uri);
            } else if (lcSourceName.endsWith(".flat")) {
                String uri = IOUtil.resolveLocalUri((String)sourceName, (String)context.getContextUri());
                generator = ComplexTypeGeneratorFactory.createFlatSourceGenerator(descriptor, context, uri);
            } else if (lcSourceName.endsWith(".xls")) {
                String uri = IOUtil.resolveLocalUri((String)sourceName, (String)context.getContextUri());
                generator = ComplexTypeGeneratorFactory.createXLSSourceGenerator(descriptor, context, uri);
            } else {
                try {
                    BasicParser parser = new BasicParser();
                    Object sourceObject = parser.resolveConstructionOrReference(sourceName, (ClassProvider)context, (Context)context);
                    return ComplexTypeGeneratorFactory.createSourceGeneratorFromObject(descriptor, context, generator, sourceObject);
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException("Unknown source type: " + sourceName);
                }
            }
        }
        if (generator.getGeneratedType() != Entity.class) {
            generator = new SimpleTypeEntityGenerator(generator, descriptor);
        }
        if ((distribution = DescriptorUtil.getDistribution(descriptor, false, context)) != null) {
            return ComplexTypeGeneratorFactory.applyDistribution(distribution, descriptor, generator, context);
        }
        return DescriptorUtil.wrapWithProxy(generator, descriptor, context);
    }

    private static Generator<Entity> createSourceGeneratorFromObject(ComplexTypeDescriptor descriptor, BeneratorContext context, Generator<Entity> generator, Object sourceObject) {
        if (sourceObject instanceof StorageSystem) {
            StorageSystem storage = (StorageSystem)sourceObject;
            String selector = descriptor.getSelector();
            generator = new IteratingGenerator<Entity>(storage.queryEntities(descriptor.getName(), selector, (Context)context));
        } else if (sourceObject instanceof EntitySource) {
            generator = new IteratingGenerator<Entity>((EntitySource)sourceObject);
        } else if (sourceObject instanceof Generator) {
            generator = (IteratingGenerator<Entity>)sourceObject;
        } else {
            throw new UnsupportedOperationException("Source type not supported: " + sourceObject.getClass());
        }
        return generator;
    }

    private static Generator<Entity> applyDistribution(Distribution distribution, ComplexTypeDescriptor descriptor, Generator<Entity> generator, BeneratorContext context) {
        List<Entity> values = GeneratorUtil.allProducts(generator);
        if (distribution instanceof Sequence) {
            generator = new SequencedSampleGenerator<Entity>(Entity.class, (Sequence)distribution, (Collection<Entity>)values);
        } else if (distribution instanceof WeightFunction || distribution instanceof IndividualWeight) {
            generator = new WeightedSampleGenerator<Entity>(Entity.class, distribution, (Collection<Entity>)values);
        } else {
            throw new ConfigurationError("Not a supported distribution: " + distribution);
        }
        if (descriptor.getVariation1() != null) {
            BeanUtil.setPropertyValue(generator, (String)"variation1", (Object)descriptor.getVariation1(), (boolean)false);
        }
        if (descriptor.getVariation2() != null) {
            BeanUtil.setPropertyValue(generator, (String)"variation2", (Object)descriptor.getVariation2(), (boolean)false);
        }
        return generator;
    }

    private static Generator<Entity> createFlatSourceGenerator(ComplexTypeDescriptor descriptor, BeneratorContext context, String sourceName) {
        String pattern;
        String encoding = descriptor.getEncoding();
        if (encoding == null) {
            encoding = context.getDefaultEncoding();
        }
        if ((pattern = descriptor.getPattern()) == null) {
            throw new ConfigurationError("No pattern specified for flat file import: " + sourceName);
        }
        FlatFileColumnDescriptor[] ffcd = FlatFileUtil.parseProperties((String)pattern);
        Converter<String, String> scriptConverter = ComplexTypeGeneratorFactory.createScriptConverter(context);
        FlatFileEntitySource iterable = new FlatFileEntitySource(sourceName, descriptor, scriptConverter, encoding, ffcd);
        IteratingGenerator<Entity> generator = new IteratingGenerator<Entity>(iterable);
        return generator;
    }

    private static Converter<String, String> createScriptConverter(BeneratorContext context) {
        ConverterChain scriptConverter = new ConverterChain(new Converter[]{new ScriptConverter((Context)context), new ToStringConverter(null)});
        return scriptConverter;
    }

    private static Generator<Entity> createCSVSourceGenerator(ComplexTypeDescriptor complexType, BeneratorContext context, String sourceName) {
        Generator<Entity> generator;
        String encoding = complexType.getEncoding();
        if (encoding == null) {
            encoding = context.getDefaultEncoding();
        }
        Converter<String, String> scriptConverter = ComplexTypeGeneratorFactory.createScriptConverter(context);
        String dataset = complexType.getDataset();
        String nesting = complexType.getNesting();
        char separator = DescriptorUtil.getSeparator(complexType, context);
        if (dataset != null && nesting != null) {
            String[] dataFiles = DatasetFactory.getDataFiles(sourceName, dataset, nesting);
            Generator[] sources = new Generator[dataFiles.length];
            for (int i = 0; i < dataFiles.length; ++i) {
                sources[i] = new IteratingGenerator<Entity>(new CSVEntitySource(dataFiles[i], complexType.getName(), separator, encoding));
            }
            generator = new AlternativeGenerator<Entity>(Entity.class, sources);
        } else {
            CSVEntitySource iterable = new CSVEntitySource(sourceName, complexType.getName(), scriptConverter, separator, encoding);
            generator = new IteratingGenerator<Entity>(iterable);
        }
        generator = new ConvertingGenerator(generator, new ComponentTypeConverter(complexType));
        return generator;
    }

    private static Generator<Entity> createXLSSourceGenerator(ComplexTypeDescriptor complexType, BeneratorContext context, String sourceName) {
        Generator<Entity> generator;
        String encoding = complexType.getEncoding();
        if (encoding == null) {
            encoding = context.getDefaultEncoding();
        }
        Converter<String, String> scriptConverter = ComplexTypeGeneratorFactory.createScriptConverter(context);
        String dataset = complexType.getDataset();
        String nesting = complexType.getNesting();
        char separator = DescriptorUtil.getSeparator(complexType, context);
        if (dataset != null && nesting != null) {
            String[] dataFiles = DatasetFactory.getDataFiles(sourceName, dataset, nesting);
            Generator[] sources = new Generator[dataFiles.length];
            for (int i = 0; i < dataFiles.length; ++i) {
                sources[i] = new IteratingGenerator<Entity>(new XLSEntitySource(dataFiles[i], 0, complexType.getName()));
            }
            generator = new AlternativeGenerator<Entity>(Entity.class, sources);
        } else {
            XLSEntitySource iterable = new XLSEntitySource(sourceName, 0, complexType.getName(), scriptConverter);
            generator = new IteratingGenerator<Entity>(iterable);
        }
        generator = new ConvertingGenerator(generator, new ComponentTypeConverter(complexType));
        return generator;
    }

    private static Generator<Entity> createSyntheticEntityGenerator(ComplexTypeDescriptor complexType, boolean unique, BeneratorContext context) {
        ArrayList<ComponentBuilder> componentBuilders = new ArrayList<ComponentBuilder>();
        if (DescriptorUtil.isWrappedSimpleType(complexType)) {
            TypeDescriptor contentType = complexType.getComponent("__SIMPLE_CONTENT").getType();
            Generator<? extends Object> generator = SimpleTypeGeneratorFactory.createSimpleTypeGenerator((SimpleTypeDescriptor)contentType, false, unique, context);
            return new SimpleTypeEntityGenerator(generator, complexType);
        }
        List<ComponentDescriptor> components = complexType.getComponents();
        for (ComponentDescriptor component : components) {
            if (complexType.equals(component.getType()) || component.getMode() == Mode.ignored) continue;
            String componentName = component.getName();
            ComponentDescriptor defaultComponentConfig = context.getDefaultComponentConfig(componentName);
            if (!complexType.isDeclaredComponent(componentName) && defaultComponentConfig != null) {
                component = defaultComponentConfig;
            }
            ComponentBuilder builder = ComponentBuilderFactory.createComponentBuilder(component, context);
            componentBuilders.add(builder);
        }
        return new EntityGenerator(complexType, componentBuilders, (Context)context);
    }

    private static Generator<Entity> createMutatingEntityGenerator(ComplexTypeDescriptor descriptor, BeneratorContext context, Generator<Entity> generator) {
        ArrayList<ComponentBuilder> componentGenerators = new ArrayList<ComponentBuilder>();
        Collection<ComponentDescriptor> components = descriptor.getDeclaredComponents();
        for (ComponentDescriptor component : components) {
            if (component.getMode() == Mode.ignored || "__SIMPLE_CONTENT".equals(component.getName())) continue;
            componentGenerators.add(ComponentBuilderFactory.createComponentBuilder(component, context));
        }
        return new EntityGenerator(descriptor, generator, componentGenerators, (Context)context);
    }
}

