/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.factory;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.Generator;
import org.databene.benerator.composite.AlternativeComponentBuilder;
import org.databene.benerator.composite.ComponentBuilder;
import org.databene.benerator.composite.InstanceArrayGenerator;
import org.databene.benerator.composite.PlainComponentBuilder;
import org.databene.benerator.engine.BeneratorContext;
import org.databene.benerator.factory.DescriptorUtil;
import org.databene.benerator.factory.GeneratorFactory;
import org.databene.benerator.factory.GeneratorFactoryUtil;
import org.databene.benerator.factory.InstanceGeneratorFactory;
import org.databene.benerator.factory.TypeGeneratorFactory;
import org.databene.benerator.wrapper.IdGenerator;
import org.databene.benerator.wrapper.IteratingGenerator;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.TypedIterable;
import org.databene.id.IdProvider;
import org.databene.model.data.AlternativeGroupDescriptor;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.DataModel;
import org.databene.model.data.IdDescriptor;
import org.databene.model.data.PartDescriptor;
import org.databene.model.data.ReferenceDescriptor;
import org.databene.model.data.SimpleTypeDescriptor;
import org.databene.model.data.TypeDescriptor;
import org.databene.model.function.Distribution;
import org.databene.model.storage.StorageSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBuilderFactory
extends InstanceGeneratorFactory {
    private static final Log logger = LogFactory.getLog(ComponentBuilderFactory.class);
    private static DataModel dataModel = DataModel.getDefaultInstance();

    protected ComponentBuilderFactory() {
    }

    public static ComponentBuilder createComponentBuilder(ComponentDescriptor descriptor, BeneratorContext context) {
        ComponentBuilder builder;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("createComponentBuilder(" + descriptor.getName() + ')'));
        }
        if ((builder = ComponentBuilderFactory.createNullQuotaOneBuilder(descriptor)) != null) {
            return builder;
        }
        builder = ComponentBuilderFactory.createNullableBuilder(descriptor, context);
        if (builder != null) {
            return builder;
        }
        if (descriptor instanceof PartDescriptor) {
            TypeDescriptor type = descriptor.getType();
            if (type instanceof AlternativeGroupDescriptor) {
                return ComponentBuilderFactory.createAlternativeGroupBuilder((AlternativeGroupDescriptor)type, context);
            }
            return ComponentBuilderFactory.createPartBuilder((PartDescriptor)descriptor, context);
        }
        if (descriptor instanceof ReferenceDescriptor) {
            return ComponentBuilderFactory.createReferenceBuilder((ReferenceDescriptor)descriptor, context);
        }
        if (descriptor instanceof IdDescriptor) {
            return ComponentBuilderFactory.createIdBuilder((IdDescriptor)descriptor, context);
        }
        throw new ConfigurationError("Unsupported element: " + descriptor.getClass());
    }

    private static ComponentBuilder createNullQuotaOneBuilder(ComponentDescriptor descriptor) {
        Generator<? extends Object> generator = InstanceGeneratorFactory.createNullQuotaOneGenerator(descriptor);
        return generator != null ? new PlainComponentBuilder(descriptor.getName(), generator) : null;
    }

    private static ComponentBuilder createNullableBuilder(ComponentDescriptor descriptor, BeneratorContext context) {
        Generator<? extends Object> generator = InstanceGeneratorFactory.createNullableGenerator(descriptor, context);
        return generator != null ? new PlainComponentBuilder(descriptor.getName(), generator) : null;
    }

    private static ComponentBuilder createAlternativeGroupBuilder(AlternativeGroupDescriptor type, BeneratorContext context) {
        int i = 0;
        List<ComponentDescriptor> components = type.getComponents();
        ComponentBuilder[] builders = new ComponentBuilder[components.size()];
        for (ComponentDescriptor component : components) {
            builders[i++] = ComponentBuilderFactory.createComponentBuilder(component, context);
        }
        return new AlternativeComponentBuilder(builders);
    }

    public static ComponentBuilder createPartBuilder(PartDescriptor part, BeneratorContext context) {
        Generator<? extends Object> generator = ComponentBuilderFactory.createSingleInstanceGenerator(part, context);
        generator = ComponentBuilderFactory.createMultiplicityWrapper(part, generator, context);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created " + generator));
        }
        return new PlainComponentBuilder(part.getName(), generator);
    }

    public static ComponentBuilder createReferenceBuilder(ReferenceDescriptor descriptor, BeneratorContext context) {
        TypeDescriptor typeDescriptor = descriptor.getType();
        String targetTypeName = descriptor.getTargetTye();
        ComplexTypeDescriptor targetType = (ComplexTypeDescriptor)dataModel.getTypeDescriptor(targetTypeName);
        Generator<Object> generator = null;
        if (targetType == null) {
            throw new ConfigurationError("Type not defined: " + targetTypeName);
        }
        String sourceName = typeDescriptor.getSource();
        if (sourceName == null) {
            throw new ConfigurationError("'source' is not set for " + descriptor);
        }
        Object sourceObject = context.get(sourceName);
        if (!(sourceObject instanceof StorageSystem)) {
            throw new ConfigurationError("Not a supported source type: " + sourceName);
        }
        StorageSystem sourceSystem = (StorageSystem)sourceObject;
        String selector = typeDescriptor.getSelector();
        TypedIterable entityIds = sourceSystem.queryEntityIds(targetTypeName, selector, (Context)context);
        generator = new IteratingGenerator(entityIds);
        Distribution distribution = DescriptorUtil.getDistribution(descriptor.getType(), descriptor.isUnique(), context);
        generator = distribution != null ? TypeGeneratorFactory.applyDistribution(descriptor.getType(), distribution, generator) : DescriptorUtil.wrapWithProxy(generator, descriptor.getType(), context);
        generator = ComponentBuilderFactory.createMultiplicityWrapper(descriptor, generator, context);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created " + generator));
        }
        return new PlainComponentBuilder(descriptor.getName(), generator);
    }

    public static ComponentBuilder createIdBuilder(IdDescriptor descriptor, BeneratorContext context) {
        IdProvider idProvider = DescriptorUtil.getIdProvider(descriptor, context);
        Generator<Object> generator = new IdGenerator(idProvider);
        generator = TypeGeneratorFactory.createTypeConvertingGenerator((SimpleTypeDescriptor)descriptor.getType(), generator);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created " + generator));
        }
        return new PlainComponentBuilder(descriptor.getName(), generator);
    }

    static Generator<Object> createMultiplicityWrapper(ComponentDescriptor instance, Generator<? extends Object> generator, BeneratorContext context) {
        Long maxCount = DescriptorUtil.getMaxCount(instance, context);
        long minCount = DescriptorUtil.getMinCount(instance, context);
        if (maxCount != null && maxCount != 1L && minCount != 1L) {
            InstanceArrayGenerator<? extends Object> wrapper = new InstanceArrayGenerator<Object>(generator);
            GeneratorFactoryUtil.mapDetailsToBeanProperties(instance, wrapper, (Context)context);
            wrapper.setCountDistribution(DescriptorUtil.getCountDistribution(instance));
            if (maxCount != null) {
                wrapper.setMaxCount(maxCount);
            }
            wrapper.setMinCount(minCount);
            generator = wrapper;
        }
        return GeneratorFactory.wrapNullQuota(generator, DescriptorUtil.getNullQuota(instance));
    }
}

