/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.factory;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import org.databene.benerator.Generator;
import org.databene.benerator.engine.BeneratorContext;
import org.databene.benerator.factory.ComponentBuilderFactory;
import org.databene.benerator.factory.GeneratorFactoryUtil;
import org.databene.benerator.parser.BasicParser;
import org.databene.benerator.parser.Construction;
import org.databene.benerator.parser.Expression;
import org.databene.benerator.parser.ParametrizedConstruction;
import org.databene.benerator.wrapper.CyclicGeneratorProxy;
import org.databene.benerator.wrapper.GeneratorProxy;
import org.databene.benerator.wrapper.RepeatGeneratorProxy;
import org.databene.benerator.wrapper.SkipGeneratorProxy;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.Converter;
import org.databene.commons.Escalator;
import org.databene.commons.LocaleUtil;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.StringCharacterIterator;
import org.databene.commons.StringUtil;
import org.databene.commons.TimeUtil;
import org.databene.commons.Validator;
import org.databene.commons.bean.ClassProvider;
import org.databene.commons.converter.ConverterChain;
import org.databene.commons.converter.FormatFormatConverter;
import org.databene.commons.converter.ToStringConverter;
import org.databene.commons.validator.AndValidator;
import org.databene.id.GlobalIdProviderFactory;
import org.databene.id.IdProvider;
import org.databene.id.IdProviderFactory;
import org.databene.id.IdStrategy;
import org.databene.model.Processor;
import org.databene.model.consumer.Consumer;
import org.databene.model.consumer.ConsumerChain;
import org.databene.model.consumer.ProcessorToConsumerAdapter;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.Entity;
import org.databene.model.data.IdDescriptor;
import org.databene.model.data.InstanceDescriptor;
import org.databene.model.data.TypeDescriptor;
import org.databene.model.function.Distribution;
import org.databene.model.function.FeatureWeight;
import org.databene.model.function.Sequence;
import org.databene.model.storage.StorageSystem;
import org.databene.model.storage.StorageSystemConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorUtil {
    private static final GlobalIdProviderFactory GLOBAL_ID_PROVIDER_FACTORY = new GlobalIdProviderFactory();
    private static final BasicParser basicParser = new BasicParser();
    private static final Escalator escalator = new LoggerEscalator();

    private DescriptorUtil() {
    }

    public static boolean isWrappedSimpleType(ComplexTypeDescriptor complexType) {
        List<ComponentDescriptor> components = complexType.getComponents();
        return components.size() == 1 && "__SIMPLE_CONTENT".equals(components.get(0).getName());
    }

    public static Distribution getDistribution(TypeDescriptor descriptor, boolean unique, BeneratorContext context) {
        String spec = descriptor.getDistribution();
        if (StringUtil.isEmpty((String)spec)) {
            return unique ? Sequence.BIT_REVERSE : null;
        }
        if (spec.startsWith("weighted[") && spec.endsWith("]")) {
            return new FeatureWeight(spec.substring("weighted[".length(), spec.length() - 1));
        }
        if ("weighted".equals(spec)) {
            return new FeatureWeight(null);
        }
        Distribution result = Sequence.getInstance(spec, false);
        if (result == null) {
            result = (Distribution)basicParser.resolveConstructionOrReference(spec, (ClassProvider)context, (Context)context);
        }
        if (result == null) {
            throw new ConfigurationError("Distribution not found: " + spec);
        }
        return result;
    }

    public static Generator<? extends Object> getGeneratorByName(TypeDescriptor descriptor, BeneratorContext context) {
        Generator generator = null;
        String generatorClassName = descriptor.getGenerator();
        if (generatorClassName != null) {
            generator = (Generator)basicParser.resolveConstructionOrReference(generatorClassName, (ClassProvider)context, (Context)context);
            GeneratorFactoryUtil.mapDetailsToBeanProperties(descriptor, generator, (Context)context);
        }
        return generator;
    }

    public static Validator getValidator(TypeDescriptor descriptor, BeneratorContext context) {
        String validatorSpec = descriptor.getValidator();
        if (StringUtil.isEmpty((String)validatorSpec)) {
            return null;
        }
        Validator result = null;
        StringCharacterIterator iterator = new StringCharacterIterator(validatorSpec);
        boolean done = false;
        do {
            Validator tmp = (Validator)basicParser.resolveConstructionOrReference(iterator, (ClassProvider)context, (Context)context);
            if (result == null) {
                result = tmp;
            } else if (result instanceof AndValidator) {
                ((AndValidator)result).add(tmp);
            } else {
                result = new AndValidator(new Validator[]{result, tmp});
            }
            iterator.skipWhitespace();
            if (!iterator.hasNext()) {
                done = true;
                continue;
            }
            if (iterator.peekNext() != ',') {
                done = true;
                continue;
            }
            iterator.next();
        } while (!done);
        return result;
    }

    public static Converter getConverter(TypeDescriptor descriptor, BeneratorContext context) {
        String converterSpec = descriptor.getConverter();
        if (StringUtil.isEmpty((String)converterSpec)) {
            return null;
        }
        StringCharacterIterator iterator = new StringCharacterIterator(converterSpec);
        Converter result = null;
        boolean done = false;
        do {
            Converter tmp = DescriptorUtil.parseSingleConverterSpec(iterator, context);
            if (result == null) {
                result = tmp;
            } else if (result instanceof ConverterChain) {
                ((ConverterChain)result).add(new Converter[]{tmp});
            } else {
                result = new ConverterChain(new Converter[]{result, tmp});
            }
            iterator.skipWhitespace();
            if (!iterator.hasNext()) {
                done = true;
                continue;
            }
            if (iterator.peekNext() != ',') {
                done = true;
                continue;
            }
            iterator.next();
        } while (!done);
        return result;
    }

    public static ConsumerChain<Entity> parseConsumersSpec(String consumerSpec, BeneratorContext context) {
        if (StringUtil.isEmpty((String)consumerSpec)) {
            return null;
        }
        StringCharacterIterator iterator = new StringCharacterIterator(consumerSpec);
        ConsumerChain<Entity> result = new ConsumerChain<Entity>(new Consumer[0]);
        boolean done = false;
        do {
            Consumer<Entity> consumer;
            if ((consumer = DescriptorUtil.parseSingleConsumer(iterator, true, context)) != null) {
                result.addComponent(consumer);
            }
            iterator.skipWhitespace();
            if (!iterator.hasNext()) {
                done = true;
                continue;
            }
            if (iterator.peekNext() != ',') {
                done = true;
                continue;
            }
            iterator.next();
        } while (!done);
        return result;
    }

    private static Consumer<Entity> parseSingleConsumer(StringCharacterIterator consumerSpec, boolean insert, BeneratorContext context) {
        Expression expression = basicParser.parseConstructionOrReference(consumerSpec, context, (Context)context);
        Object consumer = expression.evaluate();
        if (consumer == null) {
            throw new ConfigurationError("Consumer not found: " + consumerSpec);
        }
        if (consumer instanceof StorageSystem) {
            return new StorageSystemConsumer((StorageSystem)consumer, insert);
        }
        if (consumer instanceof Consumer) {
            return (Consumer)consumer;
        }
        if (consumer instanceof Processor) {
            return new ProcessorToConsumerAdapter((Processor)consumer);
        }
        throw new UnsupportedOperationException("Consumer type not supported: " + consumer.getClass());
    }

    public static Locale getLocale(TypeDescriptor descriptor) {
        Locale locale = descriptor.getLocale();
        if (locale == null) {
            locale = (Locale)descriptor.getDetailDefault("locale");
        }
        if (locale == null) {
            locale = LocaleUtil.getFallbackLocale();
        }
        return locale;
    }

    public static DateFormat getPatternAsDateFormat(TypeDescriptor descriptor) {
        String pattern = descriptor.getPattern();
        if (pattern != null) {
            return new SimpleDateFormat(pattern);
        }
        return TimeUtil.createDefaultDateFormat();
    }

    public static boolean isUnique(InstanceDescriptor descriptor) {
        Boolean unique = descriptor.isUnique();
        if (unique == null) {
            unique = false;
        }
        return unique;
    }

    public static double getNullQuota(InstanceDescriptor descriptor) {
        Double nullQuota = descriptor.getNullQuota();
        if (nullQuota == null) {
            nullQuota = 0.0;
        }
        return nullQuota;
    }

    public static <T> Generator<T> wrapWithProxy(Generator<T> generator, TypeDescriptor descriptor, BeneratorContext context) {
        Boolean cyclic = descriptor.isCyclic();
        if (cyclic == null) {
            cyclic = false;
        }
        Long proxyParam1 = null;
        Long proxyParam2 = null;
        String proxySpec = descriptor.getProxy();
        if (proxySpec != null) {
            proxyParam1 = descriptor.getProxyParam1();
            proxyParam2 = descriptor.getProxyParam2();
        }
        return DescriptorUtil.wrapWithProxy(generator, cyclic, proxySpec, proxyParam1, proxyParam2, context);
    }

    public static <T> Generator<T> wrapWithProxy(Generator<T> generator, boolean cyclic, String proxySpec, Long proxyParam1, Long proxyParam2, BeneratorContext context) {
        GeneratorProxy proxy = DescriptorUtil.createProxy(cyclic, proxySpec, proxyParam1, proxyParam2, context);
        if (proxy != null) {
            proxy.setSource(generator);
            return proxy;
        }
        return generator;
    }

    public static GeneratorProxy createProxy(boolean cyclic, String proxySpec, Long proxyParam1, Long proxyParam2, BeneratorContext context) {
        if (cyclic) {
            return new CyclicGeneratorProxy(null);
        }
        if ("repeat".equals(proxySpec)) {
            return new RepeatGeneratorProxy(null, proxyParam1, proxyParam2);
        }
        if ("skip".equals(proxySpec)) {
            return new SkipGeneratorProxy(null, proxyParam1, proxyParam2);
        }
        if (!StringUtil.isEmpty((String)proxySpec)) {
            Object instance;
            Construction construction = basicParser.parseConstruction(proxySpec, context, (Context)context);
            if (!construction.classExists()) {
                String[] parts = StringUtil.splitOnLastSeparator((String)construction.getClassName(), (char)'.');
                parts[1] = StringUtil.capitalize((String)parts[1]);
                String className = StringUtil.joinWithSeparator((char)'.', (String[])parts) + "GeneratorProxy";
                construction.setClassName(className);
            }
            if (!((instance = construction.evaluate()) instanceof GeneratorProxy)) {
                throw new ConfigurationError(instance + " does not extend the class GeneratorProxy");
            }
            return (GeneratorProxy)instance;
        }
        return null;
    }

    public static IdProvider getIdProvider(IdDescriptor descriptor, BeneratorContext context) {
        Construction construction;
        IdProviderFactory source = null;
        String sourceName = null;
        TypeDescriptor type = descriptor.getType();
        if (type != null && (sourceName = type.getSource()) != null) {
            source = (IdProviderFactory)context.get(sourceName);
        }
        String param = descriptor.getParam();
        String scope = descriptor.getScope();
        String strategySpec = descriptor.getStrategy();
        IdProvider idProvider = null;
        if (strategySpec == null) {
            strategySpec = GlobalIdProviderFactory.INCREMENT.getName();
        }
        if ((construction = basicParser.parseConstruction(strategySpec, context, (Context)context)).classExists()) {
            idProvider = (IdProvider)construction.evaluate();
        } else {
            String strategyName = construction.getClassName();
            IdStrategy idStrategy = IdStrategy.getInstance(strategyName);
            if (construction instanceof ParametrizedConstruction) {
                param = ToStringConverter.convert((Object)((ParametrizedConstruction)construction).getParams()[0], null);
            }
            if (source != null && (idProvider = source.idProvider(idStrategy, param, scope)) == null) {
                escalator.escalate("IdProvider " + sourceName + " does not support IdStrategy " + strategySpec, ComponentBuilderFactory.class, idStrategy);
            }
            if (idProvider == null) {
                idProvider = GLOBAL_ID_PROVIDER_FACTORY.idProvider(idStrategy, param, scope);
            }
            if (idProvider == null) {
                throw new ConfigurationError("unknown id generation strategy: " + idStrategy);
            }
        }
        return idProvider;
    }

    public static char getSeparator(TypeDescriptor descriptor, BeneratorContext context) {
        char separator;
        char c = separator = context != null ? (char)context.getDefaultSeparator() : (char)',';
        if (!StringUtil.isEmpty((String)descriptor.getSeparator())) {
            if (descriptor.getSeparator().length() > 1) {
                throw new ConfigurationError("A CSV separator must be one character, but was: " + descriptor.getSeparator());
            }
            separator = descriptor.getSeparator().charAt(0);
        }
        return separator;
    }

    public static long getMinCount(InstanceDescriptor descriptor, BeneratorContext context) {
        long result = 1L;
        if (descriptor.getCount() != null) {
            result = descriptor.getCount();
        } else if (descriptor.getMinCount() != null) {
            result = descriptor.getMinCount();
        }
        Long globalMaxCount = context.getMaxCount();
        if (globalMaxCount != null && globalMaxCount < result) {
            result = globalMaxCount;
        }
        return result;
    }

    public static Long getMaxCount(InstanceDescriptor descriptor, BeneratorContext context) {
        Long result = null;
        if (descriptor.getCount() != null) {
            result = descriptor.getCount();
        } else if (descriptor.getMaxCount() != null) {
            result = descriptor.getMaxCount();
        }
        Long globalMaxCount = context.getMaxCount();
        if (globalMaxCount != null) {
            result = result != null ? Math.min(result, globalMaxCount) : globalMaxCount;
        }
        return result;
    }

    public static Distribution getCountDistribution(InstanceDescriptor descriptor) {
        if (descriptor.getCountDistribution() != null) {
            return descriptor.getCountDistribution();
        }
        return Sequence.RANDOM;
    }

    private static Converter parseSingleConverterSpec(StringCharacterIterator iterator, BeneratorContext context) {
        Object converter = basicParser.resolveConstructionOrReference(iterator, (ClassProvider)context, (Context)context);
        if (converter instanceof Format) {
            converter = new FormatFormatConverter(Object.class, (Format)converter);
        }
        if (!(converter instanceof Converter)) {
            throw new ConfigurationError(converter + " is not an instance of " + Converter.class);
        }
        return (Converter)converter;
    }

    public static Object[] getValues(TypeDescriptor descriptor, BeneratorContext context) {
        String valueSpec = descriptor.getValues();
        if (!StringUtil.isEmpty((String)valueSpec)) {
            char separator = DescriptorUtil.getSeparator(descriptor, context);
            return BasicParser.parseSeparatedList(valueSpec, separator);
        }
        return null;
    }
}

