/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.factory;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.databene.benerator.Generator;
import org.databene.benerator.engine.BeneratorContext;
import org.databene.benerator.factory.DescriptorUtil;
import org.databene.benerator.primitive.BooleanGenerator;
import org.databene.benerator.primitive.CharacterGenerator;
import org.databene.benerator.primitive.datetime.DateGenerator;
import org.databene.benerator.primitive.number.adapter.BigDecimalGenerator;
import org.databene.benerator.primitive.number.adapter.FloatingPointNumberGenerator;
import org.databene.benerator.primitive.number.adapter.IntegralNumberGenerator;
import org.databene.benerator.primitive.regex.RegexStringGenerator;
import org.databene.benerator.sample.ConstantGenerator;
import org.databene.benerator.sample.SequenceGenerator;
import org.databene.benerator.sample.WeightedCSVSampleGenerator;
import org.databene.benerator.sample.WeightedSample;
import org.databene.benerator.sample.WeightedSampleGenerator;
import org.databene.benerator.wrapper.CollectionGenerator;
import org.databene.benerator.wrapper.CompositeArrayGenerator;
import org.databene.benerator.wrapper.ConvertingGenerator;
import org.databene.benerator.wrapper.IteratingGenerator;
import org.databene.benerator.wrapper.NullableGenerator;
import org.databene.benerator.wrapper.SimpleArrayGenerator;
import org.databene.benerator.wrapper.ValidatingGeneratorProxy;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.LocaleUtil;
import org.databene.commons.MathUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.Validator;
import org.databene.commons.converter.MessageConverter;
import org.databene.commons.converter.NoOpConverter;
import org.databene.commons.converter.NumberConverter;
import org.databene.commons.converter.NumberToNumberConverter;
import org.databene.commons.converter.ParseFormatConverter;
import org.databene.commons.iterator.TextLineIterable;
import org.databene.commons.validator.StringLengthValidator;
import org.databene.document.csv.CSVLineIterable;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;
import org.databene.platform.csv.CSVCellIterable;
import org.databene.regex.RegexParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorFactory {
    private static GeneratorFactory instance;

    private GeneratorFactory() {
    }

    public static GeneratorFactory getInstance() {
        if (instance == null) {
            instance = new GeneratorFactory();
        }
        return instance;
    }

    public static Generator<Boolean> getBooleanGenerator(double trueQuota, double nullQuota) {
        BooleanGenerator realGenerator = new BooleanGenerator(trueQuota);
        return GeneratorFactory.wrapNullQuota(realGenerator, nullQuota);
    }

    public static <T extends Number> Generator<T> getNumberGenerator(Class<T> type, T min, T max, T precision, Distribution distribution, double nullQuota) {
        return GeneratorFactory.getNumberGenerator(type, min, max, precision, distribution, NumberToNumberConverter.convert((Number)1, type), NumberToNumberConverter.convert((Number)1, type), nullQuota);
    }

    public static <T extends Number> Generator<T> getNumberGenerator(Class<T> type, T min, T max, T precision, Distribution distribution, T variation1, T variation2, double nullQuota) {
        int fractionDigits = Math.max(MathUtil.fractionDigits((double)min.doubleValue()), MathUtil.fractionDigits((double)precision.doubleValue()));
        int totalDigits = MathUtil.prefixDigits((double)max.doubleValue()) + fractionDigits;
        return GeneratorFactory.getNumberGenerator(type, min, max, totalDigits, fractionDigits, precision, distribution, variation1, variation2, nullQuota);
    }

    public static <T extends Number> Generator<T> getNumberGenerator(Class<T> type, T min, T max, int totalDigits, int fractionDigits, T precision, Distribution distribution, T variation1, T variation2, double nullQuota) {
        BigDecimalGenerator source;
        if (type == null) {
            throw new IllegalArgumentException("Number type is null");
        }
        if (Integer.class.equals(type) || Long.class.equals(type) || Byte.class.equals(type) || Short.class.equals(type) || BigInteger.class.equals(type)) {
            source = new IntegralNumberGenerator<T>(type, min, max, precision, distribution, variation1, variation2);
        } else if (Double.class.equals(type) || Float.class.equals(type)) {
            source = new FloatingPointNumberGenerator<Number>(type, min, (Number)GeneratorFactory.max(type, max, totalDigits, fractionDigits), (Number)GeneratorFactory.precision(type, precision, fractionDigits), distribution, variation1, variation2);
        } else if (BigDecimal.class.equals(type)) {
            source = new BigDecimalGenerator((BigDecimal)min, (BigDecimal)GeneratorFactory.max(type, max, totalDigits, fractionDigits), (BigDecimal)GeneratorFactory.precision(type, precision, fractionDigits), distribution, (BigDecimal)variation1, (BigDecimal)variation2);
        } else {
            throw new UnsupportedOperationException("Number type not supported: " + type.getName());
        }
        return GeneratorFactory.wrapNullQuota(source, nullQuota);
    }

    private static <T> T max(Class<T> type, T max, int totalDigits, int fractionDigits) {
        if (max != null) {
            return max;
        }
        return (T)NumberConverter.convert((Number)Math.pow(10.0, totalDigits - fractionDigits), type);
    }

    private static <T> T precision(Class<T> type, T precision, int fractionDigits) {
        if (precision != null) {
            return precision;
        }
        return (T)NumberConverter.convert((Number)Math.pow(10.0, -fractionDigits), type);
    }

    public static <T> Generator<T> getSampleGenerator(String uri, String encoding, Converter<String, T> converter) {
        if (converter == null) {
            converter = new NoOpConverter();
        }
        return new WeightedCSVSampleGenerator(uri, encoding, converter);
    }

    public static <T> Generator<T> getSampleGenerator(Collection<T> values) {
        Class generatedType = Object.class;
        if (values.size() > 0) {
            T first = values.iterator().next();
            generatedType = first.getClass();
        }
        return new WeightedSampleGenerator<Object>(generatedType, values);
    }

    public static <T> Generator<T> getSampleGenerator(Class<T> generatedType, Collection<T> values) {
        return new WeightedSampleGenerator<T>(generatedType, values);
    }

    public static <T> Generator<T> getSampleGenerator(T ... values) {
        Class<Object> generatedType = values.length > 0 ? values[0].getClass() : Object.class;
        return GeneratorFactory.getSampleGenerator(generatedType, values);
    }

    public static <T> Generator<T> getSampleGenerator(Class<T> generatedType, T ... values) {
        return new WeightedSampleGenerator<T>(generatedType, values);
    }

    public static <T> Generator<T> getWeightedSampleGenerator(Collection<WeightedSample<T>> samples) {
        WeightedSampleGenerator generator = new WeightedSampleGenerator();
        generator.setSamples(samples);
        return generator;
    }

    public static <T> Generator<T> getWeightedSampleGenerator(WeightedSample<T> ... samples) {
        WeightedSampleGenerator<T> generator = new WeightedSampleGenerator<T>();
        generator.setSamples(samples);
        return generator;
    }

    public static Generator<Date> getDateGenerator(Date min, Date max, long precision, Distribution distribution, double nullQuota) {
        DateGenerator generator = new DateGenerator(min, max, precision, distribution);
        return GeneratorFactory.wrapNullQuota(generator, nullQuota);
    }

    @Deprecated
    public static Generator<Date> getDateGenerator(Date min, Date max, long precision, Sequence sequence, Date variation1, Date variation2, double nullQuota) {
        DateGenerator generator = new DateGenerator(min, max, precision, sequence, variation1, variation2);
        return GeneratorFactory.wrapNullQuota(generator, nullQuota);
    }

    public static Generator<Date> getDateGenerator(String uri, String encoding, String pattern, double nullQuota) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        ParseFormatConverter converter = new ParseFormatConverter(Date.class, (Format)format);
        WeightedCSVSampleGenerator generator = new WeightedCSVSampleGenerator(uri, encoding, converter);
        return GeneratorFactory.wrapNullQuota(generator, nullQuota);
    }

    public static Generator<Character> getCharacterGenerator(Locale locale, double nullQuota) {
        return GeneratorFactory.getCharacterGenerator(null, locale, nullQuota);
    }

    public static Generator<Character> getCharacterGenerator(String pattern, Locale locale, double nullQuota) {
        Collection<Character> chars = GeneratorFactory.charSet(pattern, locale);
        CharacterGenerator generator = new CharacterGenerator(chars);
        return GeneratorFactory.wrapNullQuota(generator, nullQuota);
    }

    private static Collection<Character> charSet(String pattern, Locale locale) {
        Set chars;
        if (pattern != null) {
            try {
                chars = new RegexParser(locale).parseCharSet(pattern);
            }
            catch (ParseException e) {
                throw new ConfigurationError("Invalid regular expression.", (Throwable)e);
            }
        } else {
            chars = LocaleUtil.letters((Locale)locale);
        }
        return chars;
    }

    public static Generator<Character> getUniqueCharacterGenerator(String pattern, Locale locale) {
        Character[] chars = (Character[])CollectionUtil.toArray(GeneratorFactory.charSet(pattern, locale), Character.class);
        return new SequenceGenerator<Character>(Character.class, chars);
    }

    public static Generator<Character> getCharacterGenerator(Collection<Character> characters, double nullQuota) {
        return GeneratorFactory.wrapNullQuota(new CharacterGenerator(characters), nullQuota);
    }

    public static Generator<Character> getCharacterGenerator(double nullQuota, Character ... characters) {
        return GeneratorFactory.wrapNullQuota(new CharacterGenerator(Arrays.asList(characters)), nullQuota);
    }

    public static Generator<String> getRegexStringGenerator(String pattern, int minLength, Integer maxLength, Locale locale, double nullQuota) {
        Generator<String> generator = new RegexStringGenerator(pattern, locale, maxLength, false);
        generator = new ValidatingGeneratorProxy<String>(generator, (Validator<String>)new StringLengthValidator(minLength, maxLength));
        return GeneratorFactory.wrapNullQuota(generator, nullQuota);
    }

    public static Generator<String> getUniqueRegexStringGenerator(String pattern, int minLength, Integer maxLength, Locale locale) {
        RegexStringGenerator generator = new RegexStringGenerator(pattern, locale, maxLength, true);
        return new ValidatingGeneratorProxy<String>(generator, (Validator<String>)new StringLengthValidator(minLength, maxLength));
    }

    public static <S, T> Generator<T> getConvertingGenerator(Generator<S> source, Converter<S, T> converter) {
        return new ConvertingGenerator<S, T>(source, converter);
    }

    public static Generator<String> getMessageGenerator(String pattern, int minLength, int maxLength, Generator ... sources) {
        Generator<Object> generator = new ConvertingGenerator(new CompositeArrayGenerator<Object>(Object.class, sources), new MessageConverter(pattern, null));
        generator = new ValidatingGeneratorProxy(generator, new StringLengthValidator(minLength, Integer.valueOf(maxLength)));
        return generator;
    }

    public static <C extends Collection<I>, I> Generator<C> getCollectionGenerator(Class<C> collectionType, Generator<I> source, int minLength, int maxLength, Distribution lengthDistribution) {
        return new CollectionGenerator<C, I>(collectionType, source, minLength, maxLength, lengthDistribution);
    }

    public static <T> Generator<T[]> getArrayGenerator(Generator<T> source, Class<T> type, int minLength, int maxLength, Distribution lengthDistribution) {
        return new SimpleArrayGenerator<T>(source, type, minLength, maxLength, lengthDistribution);
    }

    public static <T> Generator<T[]> getArrayGenerator(Class<T> componentType, Generator<T> ... sources) {
        return new CompositeArrayGenerator<T>(componentType, sources);
    }

    public static <T> Generator<T> getConstantGenerator(T value) {
        return new ConstantGenerator<T>(value);
    }

    public static Generator<String> getCSVCellGenerator(String uri, char separator, boolean cyclic, String proxySpec, Long proxyParam1, Long proxyParam2, BeneratorContext context) {
        IteratingGenerator<String> generator = new IteratingGenerator<String>(new CSVCellIterable(uri, separator));
        return DescriptorUtil.wrapWithProxy(generator, cyclic, proxySpec, proxyParam1, proxyParam2, context);
    }

    public static Generator<String[]> getCSVLineGenerator(String uri, char separator, boolean ignoreEmptyLines, boolean cyclic, String proxySpec, Long proxyParam1, Long proxyParam2, BeneratorContext context) {
        IteratingGenerator generator = new IteratingGenerator(new CSVLineIterable(uri, separator, ignoreEmptyLines, SystemInfo.getFileEncoding()));
        return DescriptorUtil.wrapWithProxy(generator, cyclic, proxySpec, proxyParam1, proxyParam2, context);
    }

    public static Generator<String> getTextLineGenerator(String uri, boolean cyclic, String proxySpec, Long proxyParam1, Long proxyParam2, BeneratorContext context) {
        IteratingGenerator generator = new IteratingGenerator(new TextLineIterable(uri));
        return DescriptorUtil.wrapWithProxy(generator, cyclic, proxySpec, proxyParam1, proxyParam2, context);
    }

    static <T> Generator<T> wrapNullQuota(Generator<T> source, double nullQuota) {
        Generator<T> generator = source;
        if (nullQuota > 0.0) {
            generator = new NullableGenerator<T>(source, (float)nullQuota);
        }
        return generator;
    }
}

