/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.factory;

import java.beans.PropertyDescriptor;
import org.databene.commons.BeanUtil;
import org.databene.commons.Context;
import org.databene.model.data.FeatureDescriptor;
import org.databene.model.data.FeatureDetail;
import org.databene.model.storage.StorageSystem;

public class GeneratorFactoryUtil {
    public static void mapDetailsToBeanProperties(FeatureDescriptor descriptor, Object bean, Context context) {
        for (FeatureDetail<? extends Object> detail : descriptor.getDetails()) {
            GeneratorFactoryUtil.mapDetailToBeanProperty(descriptor, detail.getName(), bean, context);
        }
    }

    public static void mapDetailToBeanProperty(FeatureDescriptor descriptor, String detailName, Object bean, Context context) {
        GeneratorFactoryUtil.setBeanProperty(bean, detailName, descriptor.getDetailValue(detailName), context);
    }

    public static void setBeanProperty(Object bean, String detailName, Object detailValue, Context context) {
        if (detailValue != null && BeanUtil.hasProperty(bean.getClass(), (String)detailName)) {
            try {
                PropertyDescriptor propertyDescriptor = BeanUtil.getPropertyDescriptor(bean.getClass(), (String)detailName);
                Class<?> propertyType = propertyDescriptor.getPropertyType();
                Object propertyValue = detailValue;
                if (detailValue instanceof String && StorageSystem.class.isAssignableFrom(propertyType)) {
                    propertyValue = context.get(propertyValue.toString());
                }
                BeanUtil.setPropertyValue((Object)bean, (String)detailName, (Object)propertyValue, (boolean)false);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error setting '" + detailName + "' of class " + bean.getClass().getName(), e);
            }
        }
    }
}

