/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.factory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.Generator;
import org.databene.benerator.engine.BeneratorContext;
import org.databene.benerator.factory.ComplexTypeGeneratorFactory;
import org.databene.benerator.factory.DescriptorUtil;
import org.databene.benerator.factory.SimpleTypeGeneratorFactory;
import org.databene.benerator.sample.ConstantGenerator;
import org.databene.benerator.wrapper.InstanceSequenceGenerator;
import org.databene.benerator.wrapper.NullableGenerator;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.InstanceDescriptor;
import org.databene.model.data.SimpleTypeDescriptor;
import org.databene.model.data.TypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceGeneratorFactory {
    private static final Log logger = LogFactory.getLog(InstanceGeneratorFactory.class);

    protected InstanceGeneratorFactory() {
    }

    public static Generator<? extends Object> createInstanceGenerator(InstanceDescriptor descriptor, BeneratorContext context) {
        Generator<? extends Object> generator = InstanceGeneratorFactory.createSingleInstanceGenerator(descriptor, context);
        generator = InstanceGeneratorFactory.createInstanceGeneratorWrapper(descriptor, generator, context);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created " + generator));
        }
        return generator;
    }

    protected static Generator<? extends Object> createSingleInstanceGenerator(InstanceDescriptor descriptor, BeneratorContext context) {
        Generator<? extends Object> generator = null;
        generator = InstanceGeneratorFactory.createNullQuotaOneGenerator(descriptor);
        if (generator == null) {
            boolean unique = DescriptorUtil.isUnique(descriptor);
            TypeDescriptor type = descriptor.getType();
            if (type instanceof SimpleTypeDescriptor) {
                generator = SimpleTypeGeneratorFactory.createSimpleTypeGenerator((SimpleTypeDescriptor)type, false, unique, context);
            } else if (type instanceof ComplexTypeDescriptor) {
                generator = ComplexTypeGeneratorFactory.createComplexTypeGenerator((ComplexTypeDescriptor)type, unique, context);
            } else {
                throw new UnsupportedOperationException("Not a supported descriptor type: " + type.getClass());
            }
            generator = DescriptorUtil.wrapWithProxy(generator, type, context);
            generator = InstanceGeneratorFactory.wrapWithNullQuota(generator, descriptor);
        }
        return generator;
    }

    private static Generator<Object> createInstanceGeneratorWrapper(InstanceDescriptor descriptor, Generator<? extends Object> typeGenerator, BeneratorContext context) {
        InstanceSequenceGenerator<Object> generator = new InstanceSequenceGenerator<Object>(typeGenerator);
        generator.setMinCount(DescriptorUtil.getMinCount(descriptor, context));
        Long maxCount = DescriptorUtil.getMaxCount(descriptor, context);
        if (maxCount != null) {
            generator.setMaxCount(maxCount);
        }
        generator.setCountDistribution(DescriptorUtil.getCountDistribution(descriptor));
        return generator;
    }

    public static Generator<? extends Object> createNullQuotaOneGenerator(InstanceDescriptor descriptor) {
        Double nullQuota = descriptor.getNullQuota();
        if (nullQuota != null && nullQuota == 1.0) {
            return new ConstantGenerator<Object>(null);
        }
        return null;
    }

    private static <T> Generator<T> wrapWithNullQuota(Generator<T> generator, InstanceDescriptor descriptor) {
        Double nullQuota = descriptor.getNullQuota();
        if (nullQuota != null && nullQuota > 0.0) {
            if (descriptor.isNullable() != null && !descriptor.isNullable().booleanValue()) {
                logger.error((Object)("nullQuota is set to " + nullQuota + " but the value is not nullable. " + "Ignoring nullQuota for: " + descriptor));
            } else {
                generator = new NullableGenerator<T>(generator, nullQuota);
            }
        }
        return generator;
    }

    public static Generator<? extends Object> createNullableGenerator(InstanceDescriptor descriptor, BeneratorContext context) {
        if (!descriptor.overwritesParent() && descriptor.isNullable().booleanValue() && context.isDefaultNull()) {
            return new ConstantGenerator<Object>(null);
        }
        return null;
    }
}

