/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.factory;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.Generator;
import org.databene.benerator.csv.WeightedDatasetCSVGenerator;
import org.databene.benerator.engine.BeneratorContext;
import org.databene.benerator.factory.ComponentBuilderFactory;
import org.databene.benerator.factory.DescriptorUtil;
import org.databene.benerator.factory.GeneratorFactory;
import org.databene.benerator.factory.TypeGeneratorFactory;
import org.databene.benerator.sample.ConstantGenerator;
import org.databene.benerator.wrapper.AccessingGenerator;
import org.databene.benerator.wrapper.AlternativeGenerator;
import org.databene.benerator.wrapper.ByteArrayGenerator;
import org.databene.benerator.wrapper.ConvertingGenerator;
import org.databene.benerator.wrapper.IteratingGenerator;
import org.databene.commons.Accessor;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;
import org.databene.commons.HeavyweightIterable;
import org.databene.commons.SystemInfo;
import org.databene.commons.TimeUtil;
import org.databene.commons.Validator;
import org.databene.commons.accessor.GraphAccessor;
import org.databene.commons.converter.AnyConverter;
import org.databene.commons.converter.ConvertingIterable;
import org.databene.commons.iterator.DefaultTypedIterable;
import org.databene.commons.validator.StringLengthValidator;
import org.databene.model.data.PrimitiveType;
import org.databene.model.data.SimpleTypeDescriptor;
import org.databene.model.data.UnionSimpleTypeDescriptor;
import org.databene.model.function.Distribution;
import org.databene.model.function.FeatureWeight;
import org.databene.model.function.Sequence;
import org.databene.model.storage.StorageSystem;
import org.databene.platform.csv.CSVCellIterable;
import org.databene.script.ScriptConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTypeGeneratorFactory
extends TypeGeneratorFactory {
    private static final FeatureWeight EMPTY_WEIGHT = new FeatureWeight(null);
    private static final Log logger = LogFactory.getLog(ComponentBuilderFactory.class);

    public static Generator<? extends Object> createSimpleTypeGenerator(SimpleTypeDescriptor descriptor, boolean nullable, boolean unique, BeneratorContext context) {
        Generator<? extends Object> generator;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("create(" + descriptor.getName() + ')'));
        }
        if ((generator = SimpleTypeGeneratorFactory.createConstructiveGenerator(descriptor, context)) == null) {
            generator = SimpleTypeGeneratorFactory.createSampleGenerator(descriptor, unique, context);
        }
        if (generator == null && nullable) {
            Class<?> javaType = descriptor.getPrimitiveType().getJavaType();
            generator = new ConstantGenerator<Object>(null, javaType);
        }
        if (generator == null) {
            generator = SimpleTypeGeneratorFactory.createDefaultGenerator(descriptor, unique, context);
        }
        if (generator == null) {
            throw new ConfigurationError("Don't know how to handle descriptor " + descriptor);
        }
        generator = SimpleTypeGeneratorFactory.wrapWithPostprocessors(generator, descriptor, context);
        generator = DescriptorUtil.wrapWithProxy(generator, descriptor, context);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created " + generator));
        }
        return generator;
    }

    private static Generator<? extends Object> createConstructiveGenerator(SimpleTypeDescriptor descriptor, BeneratorContext context) {
        Generator<? extends Object> generator = DescriptorUtil.getGeneratorByName(descriptor, context);
        if (generator == null) {
            generator = SimpleTypeGeneratorFactory.createSourceAttributeGenerator(descriptor, context);
        }
        if (generator == null) {
            generator = SimpleTypeGeneratorFactory.createScriptGenerator(descriptor, (Context)context);
        }
        return generator;
    }

    private static Generator<? extends Object> createDefaultGenerator(SimpleTypeDescriptor descriptor, boolean unique, BeneratorContext context) {
        Generator<? extends Object> generator = SimpleTypeGeneratorFactory.createTypeGenerator(descriptor, unique, context);
        if (generator == null) {
            generator = SimpleTypeGeneratorFactory.createStringGenerator(descriptor, unique);
        }
        return generator;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Generator<? extends Object> createSourceAttributeGenerator(SimpleTypeDescriptor descriptor, BeneratorContext context) {
        void var6_13;
        String source = descriptor.getSource();
        if (source == null) {
            return null;
        }
        String lcn = source.toLowerCase();
        String selector = descriptor.getSelector();
        Distribution distribution = DescriptorUtil.getDistribution(descriptor, false, context);
        if (context.get(source) != null) {
            Object sourceObject = context.get(source);
            if (sourceObject instanceof StorageSystem) {
                IteratingGenerator iteratingGenerator = new IteratingGenerator(((StorageSystem)sourceObject).query(selector, (Context)context));
            } else {
                if (!(sourceObject instanceof Generator)) throw new UnsupportedOperationException("Not a supported source: " + sourceObject);
                Generator generator = (Generator)sourceObject;
            }
        } else if (lcn.endsWith(".csv")) {
            Generator<? extends Object> generator = SimpleTypeGeneratorFactory.createCSVSourceGenerator(descriptor, source, distribution, context);
        } else if (lcn.endsWith(".txt")) {
            Generator<String> generator = GeneratorFactory.getTextLineGenerator(source, false, null, null, null, context);
        } else {
            AccessingGenerator<BeneratorContext, Object> accessingGenerator = new AccessingGenerator<BeneratorContext, Object>(Object.class, (Accessor<BeneratorContext, Object>)new GraphAccessor(source), context);
        }
        if (distribution == null || EMPTY_WEIGHT.equals(distribution)) return DescriptorUtil.wrapWithProxy(var6_13, descriptor, context);
        return TypeGeneratorFactory.applyDistribution(descriptor, distribution, (Generator<? extends Object>)var6_13);
    }

    private static Generator<? extends Object> createCSVSourceGenerator(SimpleTypeDescriptor descriptor, String source, Distribution distribution, BeneratorContext context) {
        Generator generator;
        char separator = DescriptorUtil.getSeparator(descriptor, context);
        String encoding = descriptor.getEncoding();
        if (encoding == null) {
            encoding = SystemInfo.getFileEncoding();
        }
        String dataset = descriptor.getDataset();
        String nesting = descriptor.getNesting();
        ScriptConverter preprocessor = new ScriptConverter((Context)context);
        if (dataset != null && nesting != null || EMPTY_WEIGHT.equals(distribution) || source.toLowerCase().endsWith(".wgt.csv")) {
            generator = new WeightedDatasetCSVGenerator(source, separator, dataset, nesting, encoding);
            generator = new ConvertingGenerator(generator, preprocessor);
        } else {
            CSVCellIterable src = new CSVCellIterable(source, separator);
            ConvertingIterable iterable = new ConvertingIterable((Iterable)((Object)src), (Converter)preprocessor);
            generator = new IteratingGenerator(new DefaultTypedIterable(Object.class, (HeavyweightIterable)iterable));
        }
        return generator;
    }

    private static Generator<? extends Object> createTypeGenerator(SimpleTypeDescriptor descriptor, boolean unique, BeneratorContext context) {
        if (descriptor instanceof UnionSimpleTypeDescriptor) {
            return SimpleTypeGeneratorFactory.createUnionTypeGenerator((UnionSimpleTypeDescriptor)descriptor, context);
        }
        PrimitiveType primitiveType = descriptor.getPrimitiveType();
        if (primitiveType == null) {
            return null;
        }
        Class<?> targetType = primitiveType.getJavaType();
        if (Number.class.isAssignableFrom(targetType)) {
            return SimpleTypeGeneratorFactory.createNumberGenerator(descriptor, targetType, unique, context);
        }
        if (String.class.isAssignableFrom(targetType)) {
            return SimpleTypeGeneratorFactory.createStringGenerator(descriptor, unique);
        }
        if (Boolean.class == targetType) {
            return SimpleTypeGeneratorFactory.createBooleanGenerator(descriptor);
        }
        if (Character.class == targetType) {
            return SimpleTypeGeneratorFactory.createCharacterGenerator(descriptor, unique);
        }
        if (Date.class == targetType) {
            return SimpleTypeGeneratorFactory.createDateGenerator(descriptor, unique, context);
        }
        if (Timestamp.class == targetType) {
            return SimpleTypeGeneratorFactory.createTimestampGenerator(descriptor, unique, context);
        }
        if (byte[].class == targetType) {
            return SimpleTypeGeneratorFactory.createByteArrayGenerator(descriptor);
        }
        return null;
    }

    private static Generator<? extends Object> createUnionTypeGenerator(UnionSimpleTypeDescriptor descriptor, BeneratorContext context) {
        int n = descriptor.getAlternatives().size();
        Generator[] sources = new Generator[n];
        for (int i = 0; i < n; ++i) {
            SimpleTypeDescriptor alternative = descriptor.getAlternatives().get(i);
            sources[i] = SimpleTypeGeneratorFactory.createSimpleTypeGenerator(alternative, false, false, context);
        }
        Class<?> javaType = descriptor.getPrimitiveType().getJavaType();
        return new AlternativeGenerator(javaType, sources);
    }

    private static Generator<? extends Object> createByteArrayGenerator(SimpleTypeDescriptor descriptor) {
        Generator<Byte> byteGenerator = GeneratorFactory.getNumberGenerator(Byte.class, (byte)-128, (byte)127, (byte)1, Sequence.RANDOM, 0.0);
        return new ByteArrayGenerator(byteGenerator, SimpleTypeGeneratorFactory.getMinLength(descriptor), SimpleTypeGeneratorFactory.getMaxLength(descriptor));
    }

    private static Generator<Timestamp> createTimestampGenerator(SimpleTypeDescriptor descriptor, boolean unique, BeneratorContext context) {
        Generator<Date> dateGenerator = SimpleTypeGeneratorFactory.createDateGenerator(descriptor, unique, context);
        return new ConvertingGenerator(dateGenerator, new AnyConverter(Timestamp.class));
    }

    private static Generator<Date> createDateGenerator(SimpleTypeDescriptor descriptor, boolean unique, BeneratorContext context) {
        Date min = SimpleTypeGeneratorFactory.parseDate(descriptor, "min", TimeUtil.date((int)1970, (int)0, (int)1));
        Date max = SimpleTypeGeneratorFactory.parseDate(descriptor, "max", TimeUtil.today().getTime());
        Date precisionDate = SimpleTypeGeneratorFactory.parseDate(descriptor, "precision", TimeUtil.date((int)1970, (int)0, (int)2));
        long precision = precisionDate.getTime() - TimeUtil.date((int)1970, (int)0, (int)1).getTime();
        Distribution distribution = DescriptorUtil.getDistribution(descriptor, unique, context);
        if (distribution == null) {
            distribution = Sequence.RANDOM;
        }
        if (distribution instanceof Sequence) {
            Date variation1 = SimpleTypeGeneratorFactory.parseDate(descriptor, "variation1", precisionDate);
            Date variation2 = SimpleTypeGeneratorFactory.parseDate(descriptor, "variation2", precisionDate);
            return GeneratorFactory.getDateGenerator(min, max, precision, (Sequence)distribution, variation1, variation2, 0.0);
        }
        return GeneratorFactory.getDateGenerator(min, max, precision, distribution, 0.0);
    }

    private static Generator<Character> createCharacterGenerator(SimpleTypeDescriptor descriptor, boolean unique) {
        String pattern = descriptor.getPattern();
        if (pattern == null) {
            pattern = ".";
        }
        Locale locale = DescriptorUtil.getLocale(descriptor);
        if (unique) {
            return GeneratorFactory.getUniqueCharacterGenerator(pattern, locale);
        }
        return GeneratorFactory.getCharacterGenerator(pattern, locale, 0.0);
    }

    private static Date parseDate(SimpleTypeDescriptor descriptor, String detailName, Date defaultDate) {
        try {
            String detail = (String)descriptor.getDeclaredDetailValue(detailName);
            if (detail != null) {
                DateFormat dateFormat = DescriptorUtil.getPatternAsDateFormat(descriptor);
                return dateFormat.parse(detail);
            }
            return defaultDate;
        }
        catch (ParseException e) {
            logger.error((Object)e, (Throwable)e);
            return defaultDate;
        }
    }

    private static Generator<Boolean> createBooleanGenerator(SimpleTypeDescriptor descriptor) {
        Double trueQuota = descriptor.getTrueQuota();
        if (trueQuota == null) {
            trueQuota = (Double)descriptor.getDetailDefault("trueQuota");
        }
        return GeneratorFactory.getBooleanGenerator(trueQuota, 0.0);
    }

    private static <T extends Number> Generator<T> createNumberGenerator(SimpleTypeDescriptor descriptor, Class<T> targetType, boolean unique, BeneratorContext context) {
        T max;
        T min = SimpleTypeGeneratorFactory.getNumberDetail(descriptor, "min", targetType);
        if (min.equals(max = SimpleTypeGeneratorFactory.getNumberDetail(descriptor, "max", targetType))) {
            return new ConstantGenerator<T>(min);
        }
        Integer totalDigits = SimpleTypeGeneratorFactory.getNumberDetail(descriptor, "totalDigits", Integer.class);
        Integer fractionDigits = SimpleTypeGeneratorFactory.getNumberDetail(descriptor, "fractionDigits", Integer.class);
        T precision = SimpleTypeGeneratorFactory.getNumberDetail(descriptor, "precision", targetType);
        Distribution distribution = DescriptorUtil.getDistribution(descriptor, unique, context);
        if (distribution == null) {
            distribution = Sequence.RANDOM;
        }
        T variation1 = SimpleTypeGeneratorFactory.getNumberDetail(descriptor, "variation1", targetType);
        T variation2 = SimpleTypeGeneratorFactory.getNumberDetail(descriptor, "variation2", targetType);
        return GeneratorFactory.getNumberGenerator(targetType, min, max, totalDigits, fractionDigits, precision, distribution, variation1, variation2, 0.0);
    }

    private static Generator<String> createStringGenerator(SimpleTypeDescriptor descriptor, boolean unique) {
        Locale locale;
        String pattern;
        Integer minLength;
        Integer maxLength = (Integer)descriptor.getDeclaredDetailValue("maxLength");
        if (maxLength == null) {
            maxLength = descriptor.getMaxLength();
            if (maxLength == null) {
                maxLength = (Integer)descriptor.getDetailDefault("maxLength");
            }
            if (maxLength == null || maxLength > 10000) {
                maxLength = 10000;
            }
        }
        if ((minLength = descriptor.getMinLength()) == null) {
            int defaultMinLength = (Integer)descriptor.getDetailDefault("minLength");
            minLength = Math.min(maxLength, defaultMinLength);
        }
        if ((pattern = descriptor.getPattern()) == null) {
            pattern = (String)descriptor.getDetailDefault("pattern");
        }
        if (pattern == null) {
            pattern = "[A-Z]{" + minLength + ',' + (maxLength != null ? maxLength : 30) + '}';
        }
        if ((locale = descriptor.getLocale()) == null) {
            locale = (Locale)descriptor.getDetailDefault("locale");
        }
        if (unique) {
            return GeneratorFactory.getUniqueRegexStringGenerator(pattern, minLength, maxLength, locale);
        }
        return GeneratorFactory.getRegexStringGenerator(pattern, minLength, maxLength, locale, 0.0);
    }

    protected static <T> Validator<T> createRestrictionValidator(SimpleTypeDescriptor descriptor, boolean nullable) {
        if ((descriptor.getMinLength() != null || descriptor.getMaxLength() != null) && "string".equals(descriptor.getName())) {
            Integer minLength = SimpleTypeGeneratorFactory.getMinLength(descriptor);
            Integer maxLength = SimpleTypeGeneratorFactory.getMaxLength(descriptor);
            return new StringLengthValidator(minLength.intValue(), maxLength, nullable);
        }
        return null;
    }

    protected static Integer getMinLength(SimpleTypeDescriptor descriptor) {
        Integer minLength = descriptor.getMinLength();
        if (minLength == null) {
            minLength = 0;
        }
        return minLength;
    }

    protected static Integer getMaxLength(SimpleTypeDescriptor descriptor) {
        Integer maxLength = (Integer)descriptor.getDeclaredDetailValue("maxLength");
        if (maxLength == null) {
            maxLength = descriptor.getMaxLength();
            if (maxLength == null) {
                maxLength = (Integer)descriptor.getDetailDefault("maxLength");
            }
            if (maxLength > 10000) {
                maxLength = 10000;
            }
        }
        return maxLength;
    }

    private static <T extends Number> T getNumberDetail(SimpleTypeDescriptor descriptor, String detailName, Class<T> targetType) {
        try {
            String detailValue = (String)descriptor.getDetailValue(detailName);
            if (detailValue == null) {
                detailValue = (String)descriptor.getDetailDefault(detailName);
            }
            return (T)((Number)AnyConverter.convert((Object)detailValue, targetType));
        }
        catch (ConversionException e) {
            throw new ConfigurationError((Throwable)e);
        }
    }

    private SimpleTypeGeneratorFactory() {
    }
}

