/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.factory;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.Generator;
import org.databene.benerator.engine.BeneratorContext;
import org.databene.benerator.factory.ComplexTypeGeneratorFactory;
import org.databene.benerator.factory.DescriptorUtil;
import org.databene.benerator.factory.GeneratorFactory;
import org.databene.benerator.factory.SimpleTypeGeneratorFactory;
import org.databene.benerator.primitive.ScriptGenerator;
import org.databene.benerator.sample.AbstractSampleGenerator;
import org.databene.benerator.sample.DistributingGenerator;
import org.databene.benerator.sample.SequencedSampleGenerator;
import org.databene.benerator.sample.WeightedSampleGenerator;
import org.databene.benerator.wrapper.ConvertingGenerator;
import org.databene.benerator.wrapper.ValidatingGeneratorProxy;
import org.databene.commons.ArrayUtil;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.Converter;
import org.databene.commons.TimeUtil;
import org.databene.commons.Validator;
import org.databene.commons.converter.AnyConverter;
import org.databene.commons.converter.FormatFormatConverter;
import org.databene.commons.converter.ParseFormatConverter;
import org.databene.commons.converter.String2DateConverter;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.PrimitiveType;
import org.databene.model.data.SimpleTypeDescriptor;
import org.databene.model.data.TypeDescriptor;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;
import org.databene.model.function.WeightFunction;
import org.databene.script.Script;
import org.databene.script.ScriptUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeGeneratorFactory {
    private static final Log logger = LogFactory.getLog(TypeGeneratorFactory.class);

    public static Generator<? extends Object> createTypeGenerator(TypeDescriptor descriptor, boolean unique, BeneratorContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(descriptor + ", " + unique));
        }
        if (descriptor instanceof SimpleTypeDescriptor) {
            return SimpleTypeGeneratorFactory.createSimpleTypeGenerator((SimpleTypeDescriptor)descriptor, false, unique, context);
        }
        if (descriptor instanceof ComplexTypeDescriptor) {
            return ComplexTypeGeneratorFactory.createComplexTypeGenerator((ComplexTypeDescriptor)descriptor, unique, context);
        }
        throw new UnsupportedOperationException("Descriptor type not supported: " + descriptor.getClass());
    }

    protected static Generator<? extends Object> createSampleGenerator(TypeDescriptor descriptor, boolean unique, BeneratorContext context) {
        AbstractSampleGenerator generator = null;
        Object[] values = DescriptorUtil.getValues(descriptor, context);
        if (!ArrayUtil.isEmpty((Object[])values)) {
            Distribution distribution = DescriptorUtil.getDistribution(descriptor, unique, context);
            if (distribution instanceof Sequence) {
                generator = new SequencedSampleGenerator<Object>(Object.class, (Sequence)distribution, values);
            } else if (distribution instanceof WeightFunction) {
                generator = new WeightedSampleGenerator<Object>(Object.class, (Distribution)((WeightFunction)distribution), values);
            } else if (distribution == null) {
                generator = new SequencedSampleGenerator<Object>(Object.class, values);
            } else {
                throw new ConfigurationError("Unsupported distribution type: " + distribution.getClass());
            }
        }
        return generator;
    }

    protected static Generator<? extends Object> createScriptGenerator(TypeDescriptor descriptor, Context context) {
        ScriptGenerator generator = null;
        String scriptText = descriptor.getScript();
        if (scriptText != null) {
            Script script = ScriptUtil.parseUnspecificText((String)scriptText);
            generator = new ScriptGenerator(script, context);
        }
        return generator;
    }

    protected static <T> Generator<T> createValidatingGenerator(TypeDescriptor descriptor, Generator<T> generator, BeneratorContext context) {
        Validator validator = DescriptorUtil.getValidator(descriptor, context);
        if (validator != null) {
            generator = new ValidatingGeneratorProxy<T>(generator, validator);
        }
        return generator;
    }

    protected static Generator createConvertingGenerator(TypeDescriptor descriptor, Generator generator, BeneratorContext context) {
        Converter converter = DescriptorUtil.getConverter(descriptor, context);
        if (converter != null) {
            if (descriptor.getPattern() != null && BeanUtil.hasProperty(converter.getClass(), (String)"pattern")) {
                BeanUtil.setPropertyValue((Object)converter, (String)"pattern", (Object)descriptor.getPattern(), (boolean)false);
            }
            generator = GeneratorFactory.getConvertingGenerator(generator, converter);
        }
        return generator;
    }

    static <E> Generator<E> wrapWithPostprocessors(Generator<E> generator, TypeDescriptor descriptor, BeneratorContext context) {
        generator = TypeGeneratorFactory.createConvertingGenerator(descriptor, generator, context);
        if (descriptor instanceof SimpleTypeDescriptor) {
            generator = TypeGeneratorFactory.createTypeConvertingGenerator((SimpleTypeDescriptor)descriptor, generator);
        }
        generator = TypeGeneratorFactory.createValidatingGenerator(descriptor, generator, context);
        return generator;
    }

    static <S, T> Generator<T> createTypeConvertingGenerator(SimpleTypeDescriptor descriptor, Generator<S> generator) {
        if (descriptor == null || descriptor.getPrimitiveType() == null) {
            return generator;
        }
        PrimitiveType primitiveType = descriptor.getPrimitiveType();
        Class<?> targetType = primitiveType.getJavaType();
        String2DateConverter converter = null;
        if (Date.class.equals(targetType) && generator.getGeneratedType() == String.class) {
            if (descriptor.getPattern() != null) {
                String pattern = descriptor.getPattern();
                converter = new ParseFormatConverter(Date.class, (Format)new SimpleDateFormat(pattern));
            } else {
                converter = new String2DateConverter();
            }
        } else if (String.class.equals(targetType) && generator.getGeneratedType() == Date.class) {
            if (descriptor.getPattern() != null) {
                String pattern = descriptor.getPattern();
                converter = new FormatFormatConverter(Date.class, (Format)new SimpleDateFormat(pattern));
            } else {
                converter = new FormatFormatConverter(Date.class, (Format)TimeUtil.createDefaultDateFormat());
            }
        } else {
            converter = new AnyConverter(targetType, descriptor.getPattern());
        }
        return new ConvertingGenerator(generator, converter);
    }

    public static Generator<? extends Object> applyDistribution(TypeDescriptor descriptor, Distribution distribution, Generator<? extends Object> generator) {
        return new DistributingGenerator<Object>(generator, distribution, descriptor.getVariation1(), descriptor.getVariation2());
    }
}

