/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import org.databene.benerator.Generator;
import org.databene.benerator.engine.BeneratorContext;
import org.databene.benerator.factory.TypeGeneratorFactory;
import org.databene.benerator.parser.ModelParser;
import org.databene.benerator.primitive.IncrementGenerator;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.benerator.wrapper.ConvertingGenerator;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.IOUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.MessageConverter;
import org.databene.commons.xml.XMLUtil;
import org.databene.model.data.DataModel;
import org.databene.model.data.Entity;
import org.databene.model.data.TypeDescriptor;
import org.databene.platform.xml.XMLEntityExporter;
import org.databene.platform.xml.XMLSchemaDescriptorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLFileGenerator
extends LightweightGenerator<File> {
    private String encoding = SystemInfo.getFileEncoding();
    private String root;
    private String filenamePattern;
    private Generator<String> fileNameGenerator;
    private Generator<? extends Object> contentGenerator;
    private DataModel dataModel = DataModel.getDefaultInstance();

    public XMLFileGenerator(String schemaUri, String root, String filenamePattern, String ... propertiesFiles) throws IOException {
        super(File.class);
        this.dataModel.clear();
        this.root = root;
        this.filenamePattern = filenamePattern;
        BeneratorContext context = new BeneratorContext(IOUtil.getContextUri((String)schemaUri));
        XMLSchemaDescriptorProvider xsdProvider = new XMLSchemaDescriptorProvider(schemaUri, context);
        this.dataModel.addDescriptorProvider(xsdProvider);
        this.fileNameGenerator = new ConvertingGenerator<Long, String>(new IncrementGenerator(), (Converter<Long, String>)new MessageConverter(filenamePattern, Locale.US));
        ModelParser parser = new ModelParser(context);
        for (String propertiesFile : propertiesFiles) {
            parser.importProperties(propertiesFile);
        }
        TypeDescriptor rootDescriptor = DataModel.getDefaultInstance().getTypeDescriptor(root);
        if (rootDescriptor == null) {
            throw new ConfigurationError("Type '" + root + "' not found in schema: " + schemaUri);
        }
        this.contentGenerator = TypeGeneratorFactory.createTypeGenerator(rootDescriptor, false, context);
    }

    @Override
    public boolean available() {
        return super.available() && this.contentGenerator.available();
    }

    @Override
    public void validate() {
        super.validate();
        this.contentGenerator.validate();
    }

    @Override
    public File generate() {
        Object content = this.contentGenerator.generate();
        return this.persistContent(content);
    }

    private File persistContent(Object content) {
        File file = new File(this.fileNameGenerator.generate());
        if (content instanceof Entity) {
            this.persistRootEntity((Entity)content, file);
        } else {
            this.persistRootObject(content, file);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistRootEntity(Entity entity, File file) {
        entity.setComponent("elementFormDefault", "unqualified");
        XMLEntityExporter exporter = null;
        try {
            exporter = new XMLEntityExporter(file.getAbsolutePath(), this.encoding);
            this.process(entity, exporter);
        }
        finally {
            if (exporter != null) {
                exporter.close();
            }
        }
    }

    private void process(Entity entity, XMLEntityExporter exporter) {
        exporter.startConsuming(entity);
        for (Object component : entity.getComponents().values()) {
            Object[] array;
            if (component == null) continue;
            if (component instanceof Entity) {
                this.process((Entity)component, exporter);
                continue;
            }
            if (!component.getClass().isArray()) continue;
            for (Object element : array = (Object[])component) {
                if (!(element instanceof Entity)) continue;
                this.process((Entity)element, exporter);
            }
        }
        exporter.finishConsuming(entity);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void persistRootObject(Object content, File file) {
        PrintWriter printer = null;
        try {
            printer = XMLUtil.createXMLFile((String)file.getAbsolutePath(), (String)this.encoding);
            printer.println("<" + this.root + ">" + content + "</" + this.root + ">");
        }
        catch (FileNotFoundException e) {
            try {
                throw new ConfigurationError((Throwable)e);
                catch (UnsupportedEncodingException e2) {
                    throw new ConfigurationError((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(printer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)printer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.filenamePattern + ']';
    }
}

