/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.gui;

import java.beans.PropertyDescriptor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.databene.benerator.engine.BeneratorContext;
import org.databene.benerator.gui.Setup;
import org.databene.benerator.main.DBSnapshotTool;
import org.databene.benerator.parser.ModelParser;
import org.databene.commons.BeanUtil;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.FileUtil;
import org.databene.commons.IOUtil;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.StringUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.ToStringConverter;
import org.databene.commons.maven.MavenUtil;
import org.databene.commons.ui.I18NError;
import org.databene.commons.ui.ProgressMonitor;
import org.databene.commons.xml.XMLUtil;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.DataModel;
import org.databene.model.data.FeatureDetail;
import org.databene.model.data.IdDescriptor;
import org.databene.model.data.InstanceDescriptor;
import org.databene.model.data.PartDescriptor;
import org.databene.model.data.ReferenceDescriptor;
import org.databene.model.data.SimpleTypeDescriptor;
import org.databene.model.data.TypeDescriptor;
import org.databene.platform.db.DBSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchetypeBuilder
implements Runnable {
    private static final String TEMPLATE_BEN_XML = "org/databene/benerator/gui/template.ben.xml";
    private static final String DEFAULTS_XML = "org/databene/benerator/gui/defaults.xml";
    private static final char[] LF_TAB = StringUtil.getChars((String)(SystemInfo.getLineSeparator() + "\t"));
    private static final char[] LF_TWO_TABS = StringUtil.getChars((String)(SystemInfo.getLineSeparator() + "\t\t"));
    private static final Set<String> DB_CONSTRAINT_NAMES = CollectionUtil.toSet((Object[])new String[]{"nullable", "maxLength", "type"});
    protected Setup setup;
    protected TypeDescriptor[] descriptors;
    protected TransformerHandler handler;
    protected DBSystem db;
    private Map<String, ComponentDescriptor> defaults = new HashMap<String, ComponentDescriptor>();
    private ToStringConverter toStringConverter = new ToStringConverter();
    private List<String> errors;
    private ProgressMonitor monitor;

    public ArchetypeBuilder(Setup setup, ProgressMonitor monitor) {
        this.setup = setup;
        this.errors = new ArrayList<String>();
        this.monitor = monitor;
        this.descriptors = new TypeDescriptor[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            File snapshotFile;
            if (this.setup.isDatabaseProject()) {
                this.noteMonitor("scanning database");
                if (this.monitor != null) {
                    this.monitor.setProgress(0);
                }
                this.db = new DBSystem("db", this.setup.getDbUrl(), this.setup.getDbDriver(), this.setup.getDbUser(), this.setup.getDbPassword());
                this.db.setSchema(this.setup.getDbSchema());
                DataModel.getDefaultInstance().addDescriptorProvider(this.db);
                if (this.setup.getDbSchema() != null) {
                    this.db.setSchema(this.setup.getDbSchema());
                }
                this.descriptors = this.db.getTypeDescriptors();
                if (this.monitor != null) {
                    this.monitor.setMaximum(5 + this.setup.getImportFiles().length + this.descriptors.length);
                }
                this.advanceMonitor();
            } else {
                this.monitor.setMaximum(5 + this.setup.getImportFiles().length);
            }
            String groupId = this.setup.getGroupId();
            String pkgFolder = "/" + (StringUtil.isEmpty((String)groupId) ? "" : groupId.replace('.', '/') + '/') + this.setup.getProjectName();
            this.haveSubFolder("src/main/java" + pkgFolder);
            this.haveSubFolder("src/main/resources" + pkgFolder);
            this.haveSubFolder("src/test/java" + pkgFolder);
            this.haveSubFolder("src/test/resources" + pkgFolder);
            this.createPOM();
            this.createProjectPropertiesFile();
            this.copyImportFiles();
            if (this.setup.isDatabaseProject() && "DbUnit".equals(this.setup.getDbSnapshot()) && (snapshotFile = this.createDbUnitSnapshot()) != null) {
                this.setup.addImportFile(snapshotFile);
            }
            this.createDescriptorFile();
            this.createEclipseProject();
        }
        catch (Exception e) {
            this.errors.add(e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (this.db != null) {
                this.db.close();
            }
            if (this.monitor != null) {
                this.monitor.setProgress(this.monitor.getMaximum());
            }
        }
    }

    private void createEclipseProject() {
        this.setup.projectFile(".project");
        if (this.setup.isEclipseProject()) {
            this.noteMonitor("Creating Eclipse project");
            MavenUtil.invoke((String)"eclipse:eclipse", (File)this.setup.getProjectFolder(), (!this.setup.isOffline() ? 1 : 0) != 0);
        }
        this.advanceMonitor();
    }

    private void haveSubFolder(String relativePath) {
        FileUtil.ensureDirectoryExists((File)this.setup.subDirectory(relativePath));
    }

    public String[] getErrors() {
        return (String[])CollectionUtil.toArray(this.errors, String.class);
    }

    private void advanceMonitor() {
        if (this.monitor != null) {
            this.monitor.advance();
        }
    }

    private void noteMonitor(String note) {
        if (this.monitor != null) {
            this.monitor.setNote(note);
        }
    }

    private void copyImportFiles() {
        for (File importFile : this.setup.getImportFiles()) {
            this.noteMonitor("Importing " + importFile);
            if (importFile.exists()) {
                File copy = this.setup.projectFile(importFile.getName());
                try {
                    IOUtil.copy((String)importFile.getAbsolutePath(), (String)copy.getAbsolutePath());
                }
                catch (IOException e) {
                    throw new I18NError("ErrorCopying", (Throwable)e, new Object[]{importFile.getAbsolutePath(), copy});
                }
            } else {
                this.errors.add("File not found: " + importFile);
            }
            this.advanceMonitor();
        }
    }

    private File createDbUnitSnapshot() {
        File file = this.setup.projectFile(this.setup.getProjectName() + ".dbunit.xml");
        if (!this.setup.isOverwrite() && file.exists()) {
            throw new I18NError("FileAlreadyExists", null, new Object[]{file.getAbsolutePath()});
        }
        DBSnapshotTool.export(this.setup.getDbUrl(), this.setup.getDbDriver(), this.setup.getDbSchema(), this.setup.getDbUser(), this.setup.getDbPassword(), file.getAbsolutePath(), this.monitor);
        return file;
    }

    private File createPOM() {
        this.noteMonitor("creating pom");
        File file = this.setup.projectFile("pom.xml");
        try {
            String content = IOUtil.getContentOfURI((String)"org/databene/benerator/gui/template-pom.xml");
            if (!this.setup.isDatabaseProject()) {
                content = StringUtil.removeSection((String)content, (String)"<dbUrl>", (String)"</dbPassword>");
            }
            content = this.replaceVariables(content);
            IOUtil.writeTextFile((String)file.getAbsolutePath(), (String)content, (String)this.setup.getEncoding());
        }
        catch (IOException e) {
            throw new I18NError("ErrorCreatingFile", (Throwable)e, new Object[]{file});
        }
        this.advanceMonitor();
        return file;
    }

    private File createProjectPropertiesFile() {
        String filename = this.setup.getProjectName() + ".properties";
        this.noteMonitor("creating " + filename);
        File file = this.setup.projectFile(filename);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            writer.println("benerator.defaultEncoding=" + this.setup.getEncoding());
        }
        catch (IOException e) {
            try {
                throw new I18NError("ErrorCreatingFile", (Throwable)e, new Object[]{file});
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        this.advanceMonitor();
        return file;
    }

    private File createDescriptorFile() {
        String filename = this.setup.getProjectName() + ".ben.xml";
        this.noteMonitor("Creating " + filename);
        File file = this.setup.projectFile(filename);
        try {
            SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            this.handler = tf.newTransformerHandler();
            Transformer serializer = this.handler.getTransformer();
            serializer.setOutputProperty("method", "xml");
            serializer.setOutputProperty("encoding", this.setup.getEncoding());
            serializer.setOutputProperty("indent", "yes");
            FileOutputStream out = new FileOutputStream(file);
            this.handler.setResult(new StreamResult(out));
            this.handler.startDocument();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            InputStream in = IOUtil.getInputStreamForURI((String)TEMPLATE_BEN_XML);
            saxParser.parse(in, (DefaultHandler)new SaxHandler(this.handler));
        }
        catch (TransformerConfigurationException e) {
            throw new ConfigurationError((Throwable)e);
        }
        catch (SAXException e) {
            throw new ConfigurationError("Error in initializing XML file", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error writing file " + file, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing file " + file, e);
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationError("Error in initializing SAX parser", (Throwable)e);
        }
        this.advanceMonitor();
        return file;
    }

    String replaceVariables(String text) {
        for (PropertyDescriptor property : BeanUtil.getPropertyDescriptors(Setup.class)) {
            String propertyName = property.getName();
            String var = "${setup." + propertyName + "}";
            Object propertyValue = BeanUtil.getPropertyValue((Object)this.setup, (String)propertyName);
            String propertyString = ToStringConverter.convert((Object)propertyValue, null);
            text = text.replace(var, propertyString);
        }
        return text;
    }

    void importFiles() throws SAXException {
        File[] importFiles = this.setup.getImportFiles();
        if (importFiles != null) {
            for (File importFile : importFiles) {
                this.importFile(importFile);
            }
        }
    }

    private void importFile(File importFile) throws SAXException {
        this.writeLfTab();
        String filename = importFile.getName();
        if (filename.toLowerCase().endsWith(".properties")) {
            this.writeElement("include", "uri", filename);
        } else if (filename.toLowerCase().endsWith(".dbunit.xml")) {
            this.writeElement("create-entities", "source", filename, "consumer", "db");
        } else if (filename.toLowerCase().endsWith(".sql")) {
            this.writeElement("execute", "uri", filename, "target", "db");
        } else {
            this.writeElement("execute", "uri", filename);
        }
    }

    private void writeElement(String name, String ... keyValuePairs) throws SAXException {
        if (keyValuePairs.length % 2 == 1) {
            throw new IllegalArgumentException();
        }
        this.writeLfTab();
        AttributesImpl attributes = new AttributesImpl();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            attributes.addAttribute("", "", keyValuePairs[i], "CDATA", keyValuePairs[i + 1]);
        }
        this.handler.startElement("", "", name, attributes);
        this.handler.endElement("", "", name);
    }

    private void writeLfTab() throws SAXException {
        this.handler.characters(LF_TAB, 0, LF_TAB.length);
    }

    void createEntities() throws SAXException {
        this.parseDefaults();
        for (TypeDescriptor descriptor : this.descriptors) {
            ComplexTypeDescriptor complexType = (ComplexTypeDescriptor)descriptor;
            String name = complexType.getName();
            this.applyDefaults(complexType);
            InstanceDescriptor iDesc = new InstanceDescriptor(name, complexType.getName());
            long count = this.db.countEntities(name);
            iDesc.setCount(count);
            this.createEntity(iDesc);
        }
    }

    private void createEntity(InstanceDescriptor descriptor) throws SAXException {
        descriptor.setCount(0L);
        AttributesImpl attributes = new AttributesImpl();
        for (FeatureDetail<? extends Object> detail : descriptor.getDetails()) {
            Object value = detail.getValue();
            if (value == null || NullSafeComparator.equals((Object)value, (Object)detail.getDefault())) continue;
            attributes.addAttribute("", "", detail.getName(), "CDATA", this.toStringConverter.convert(value));
        }
        attributes.addAttribute("", "", "consumer", "CDATA", "db");
        this.writeLfTab();
        this.handler.startElement("", "", "create-entities", attributes);
        ComplexTypeDescriptor type = (ComplexTypeDescriptor)descriptor.getType();
        if (type.getComponents().size() > 0) {
            for (ComponentDescriptor cd : type.getComponents()) {
                this.attribute(cd);
            }
        }
        this.writeLfTab();
        this.handler.endElement("", "", "create-entities");
        this.writeLfTab();
    }

    private void attribute(ComponentDescriptor component) throws SAXException {
        boolean nullable;
        boolean bl = nullable = component.isNullable() == null || component.isNullable() != false;
        if (component.getMaxCount() != null && component.getMaxCount() == 1L) {
            component.setMaxCount(null);
        }
        if (component.getMinCount() != null && component.getMinCount() == 1L) {
            component.setMinCount(null);
        }
        if (nullable) {
            component.setNullable(null);
        }
        String elementName = null;
        if (component instanceof PartDescriptor) {
            elementName = "attribute";
        } else if (component instanceof ReferenceDescriptor) {
            elementName = "reference";
        } else if (component instanceof IdDescriptor) {
            elementName = "id";
        } else {
            throw new UnsupportedOperationException("Component descriptor type not supported: " + component.getClass().getSimpleName());
        }
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "", "name", "CDATA", component.getName());
        SimpleTypeDescriptor type = (SimpleTypeDescriptor)(component.getTypeName() != null ? DataModel.getDefaultInstance().getTypeDescriptor(component.getTypeName()) : component.getLocalType());
        if (type != null) {
            for (FeatureDetail<? extends Object> detail : type.getDetails()) {
                this.format(detail, attributes);
            }
        }
        for (FeatureDetail<? extends Object> detail : component.getDetails()) {
            this.format(detail, attributes);
        }
        if (nullable) {
            attributes.addAttribute("", "", "nullQuota", "CDATA", "1");
        }
        this.handler.characters(LF_TWO_TABS, 0, LF_TWO_TABS.length);
        StringBuilder builder = new StringBuilder();
        builder.append(elementName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            builder.append(' ').append(attributes.getQName(i)).append("=\"").append(attributes.getValue(i)).append('\"');
        }
        builder.append(" /");
        char[] chars = StringUtil.getChars((StringBuilder)builder);
        this.handler.comment(chars, 0, builder.length());
    }

    private void format(FeatureDetail<? extends Object> detail, AttributesImpl attributes) {
        if (!"name".equals(detail.getName()) && detail.getValue() != null && !this.dbConstraint(detail.getName())) {
            attributes.addAttribute("", "", detail.getName(), "CDATA", this.toStringConverter.convert(detail.getValue()));
        }
    }

    private boolean dbConstraint(String name) {
        return DB_CONSTRAINT_NAMES.contains(name);
    }

    private void parseDefaults() {
        try {
            Document document = XMLUtil.parse((InputStream)IOUtil.getInputStreamForURI((String)DEFAULTS_XML));
            Element root = document.getDocumentElement();
            Element[] childElements = XMLUtil.getChildElements((Element)root);
            String projectPath = this.setup.getProjectFolder().getCanonicalPath();
            ModelParser parser = new ModelParser(new BeneratorContext(projectPath));
            for (Element node : childElements) {
                ComponentDescriptor component = parser.parseSimpleTypeComponent(node, null);
                this.defaults.put(component.getName(), component);
            }
        }
        catch (IOException e) {
            throw new ConfigurationError((Throwable)e);
        }
    }

    private void applyDefaults(ComplexTypeDescriptor complexType) {
        ArrayList<ComponentDescriptor> overrides = new ArrayList<ComponentDescriptor>();
        for (ComponentDescriptor component : complexType.getComponents()) {
            String name = component.getName();
            if (!this.defaults.containsKey(name)) continue;
            overrides.add(this.defaults.get(name));
        }
        for (ComponentDescriptor override : overrides) {
            complexType.setComponent(override);
        }
    }

    class SaxHandler
    extends DefaultHandler {
        private static final String CREATE_ENTITIES = "${create-entities}";
        private static final String IMPORT_FILES = "${import-files}";
        private TransformerHandler handler;
        private boolean comment;

        public SaxHandler(TransformerHandler handler) {
            this.handler = handler;
            this.comment = false;
        }

        public void startDocument() throws SAXException {
            this.handler.startDocument();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("comment".equals(qName)) {
                this.comment = true;
            } else {
                AttributesImpl out = new AttributesImpl();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String value = attributes.getValue(i);
                    value = ArchetypeBuilder.this.replaceVariables(value);
                    out.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), value);
                }
                this.handler.startElement(uri, localName, qName, out);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.comment) {
                this.handler.comment(ch, start, length);
            } else {
                String text = new String(ch, start, length);
                if (text.contains("${setup.projectName}")) {
                    this.writeText(text.replace("${setup.projectName}", ArchetypeBuilder.this.setup.getProjectName()));
                } else if (text.contains(IMPORT_FILES)) {
                    int index = text.indexOf(IMPORT_FILES, start);
                    this.handler.characters(ch, start, index - start);
                    ArchetypeBuilder.this.importFiles();
                    this.handler.characters(ch, index + IMPORT_FILES.length(), length - index - IMPORT_FILES.length());
                } else if (text.contains(CREATE_ENTITIES)) {
                    int index = text.indexOf(CREATE_ENTITIES, start);
                    this.handler.characters(ch, start, index - start);
                    ArchetypeBuilder.this.createEntities();
                    this.handler.characters(ch, index + CREATE_ENTITIES.length(), length - index - CREATE_ENTITIES.length());
                } else {
                    this.handler.characters(ch, start, length);
                }
            }
        }

        private void writeText(String text) throws SAXException {
            char[] out = StringUtil.getChars((String)text);
            this.handler.characters(out, 0, out.length);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("comment".equals(qName)) {
                this.comment = false;
            } else {
                this.handler.endElement(uri, localName, qName);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.handler.ignorableWhitespace(ch, start, length);
        }

        public void endDocument() throws SAXException {
            this.handler.endDocument();
        }
    }
}

