/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.DriverManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.databene.benerator.gui.ArchetypeBuilder;
import org.databene.benerator.gui.Setup;
import org.databene.commons.FileUtil;
import org.databene.commons.converter.ToStringConverter;
import org.databene.commons.ui.FileOperation;
import org.databene.commons.ui.FileTypeSupport;
import org.databene.commons.ui.I18NError;
import org.databene.commons.ui.I18NSupport;
import org.databene.commons.ui.ProgressMonitor;
import org.databene.gui.swing.AlignedPane;
import org.databene.gui.swing.SwingUtil;
import org.databene.gui.swing.delegate.PropertyCheckBox;
import org.databene.gui.swing.delegate.PropertyComboBox;
import org.databene.gui.swing.delegate.PropertyFileField;
import org.databene.gui.swing.delegate.PropertyFileList;
import org.databene.gui.swing.delegate.PropertyTextField;

public class CreateProjectPanel
extends JPanel {
    private static final long serialVersionUID = 167461075459757736L;
    private static final int WIDE = 30;
    Setup setup;
    I18NSupport i18n;
    PropertyFileField folderField;
    JButton createButton;
    JCheckBox dbProjectCheckBox;
    JTextField dbUrlField;
    JTextField dbDriverField;
    JTextField dbUserField;
    JTextField dbSchemaField;
    JTextField dbPasswordField;
    JComboBox dbSnapshotField;
    JButton testButton;

    public CreateProjectPanel(Setup setup, I18NSupport i18n) {
        super(new BorderLayout());
        this.setup = setup;
        this.i18n = i18n;
        this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.add(this.createPropertiesPane(), "Center");
        this.add(this.createButtonPane(), "South");
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateProjectPanel.this.exit();
            }
        }, stroke, 2);
    }

    private Component createButtonPane() {
        JPanel pane = new JPanel();
        this.createButton = this.createButton("create", new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                new Thread(new Creator()).start();
            }
        });
        pane.add(this.createButton);
        pane.add(this.createButton("cancel", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateProjectPanel.this.exit();
            }
        }));
        return pane;
    }

    private Component createPropertiesPane() {
        AlignedPane pane = AlignedPane.createVerticalPane((int)4);
        this.createTextFieldRow("projectName", pane);
        this.folderField = new PropertyFileField((Object)this.setup, "projectFolder", 30, FileTypeSupport.directoriesOnly, FileOperation.save);
        this.folderField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File folder = CreateProjectPanel.this.folderField.getFile();
                if (!CreateProjectPanel.this.setup.isOverwrite() && folder.exists() && !FileUtil.isEmptyFolder((File)folder)) {
                    CreateProjectPanel.this.showErrors(CreateProjectPanel.this.i18n.getString("error.projectFolderNotEmpty"));
                }
            }
        });
        pane.addRow(this.i18n.getString("projectFolder"), (Component)this.folderField);
        pane.addSeparator();
        this.createTextField("groupId", pane);
        this.createTextField("version", pane);
        pane.endRow();
        this.createCheckBox("eclipseProject", pane);
        this.createCheckBox("overwrite", pane);
        pane.endRow();
        this.dbProjectCheckBox = this.createCheckBox("databaseProject", pane);
        this.dbProjectCheckBox.addActionListener(new DBProjectListener());
        this.createCheckBox("offline", pane);
        pane.endRow();
        pane.addSeparator();
        this.dbUrlField = this.createTextFieldRow("dbUrl", pane);
        this.dbDriverField = this.createTextFieldRow("dbDriver", pane);
        this.dbUserField = this.createTextField("dbUser", pane);
        this.dbSchemaField = this.createTextField("dbSchema", pane);
        pane.endRow();
        this.dbPasswordField = this.createTextField("dbPassword", pane);
        pane.addElement((Component)new JLabel(""));
        this.testButton = this.createButton("testConnection", new TestConnectionListener());
        pane.addElement((Component)this.testButton);
        pane.endRow();
        this.dbSnapshotField = this.createComboBox("dbSnapshot", pane, "DbUnit", "none");
        pane.addSeparator();
        PropertyFileList importList = new PropertyFileList((Object)this.setup, "importFiles", this.i18n);
        pane.addRow(this.i18n.getString("importFiles"), (Component)importList);
        pane.addSeparator();
        this.createTextField("encoding", pane);
        this.createTextField("lineSeparator", pane);
        pane.endRow();
        this.createTextField("locale", pane);
        this.createTextField("dataset", pane);
        pane.endRow();
        pane.addSeparator();
        return pane;
    }

    private JCheckBox createCheckBox(String propertyName, AlignedPane pane) {
        PropertyCheckBox checkBox = new PropertyCheckBox((Object)this.setup, propertyName, this.i18n.getString(propertyName));
        pane.addElement("", (Component)checkBox);
        return checkBox;
    }

    private JComboBox createComboBox(String propertyName, AlignedPane pane, String ... options) {
        PropertyComboBox comboBox = new PropertyComboBox((Object)this.setup, propertyName, this.i18n, "dbSnapshot.", (Object[])options);
        String label = this.i18n.getString(propertyName);
        pane.addRow(label, (Component)comboBox);
        return comboBox;
    }

    private JTextField createTextFieldRow(String propertyName, AlignedPane pane) {
        PropertyTextField textfield = new PropertyTextField((Object)this.setup, propertyName, 30);
        String label = this.i18n.getString(propertyName);
        pane.addRow(label, (Component)textfield);
        return textfield;
    }

    private JTextField createTextField(String propertyName, AlignedPane pane) {
        PropertyTextField textfield = new PropertyTextField((Object)this.setup, propertyName, 15);
        String label = this.i18n.getString(propertyName);
        pane.addElement(label, (Component)textfield);
        return textfield;
    }

    private JButton createButton(String label, ActionListener listener) {
        JButton button = new JButton(this.i18n.getString(label));
        button.addActionListener(listener);
        return button;
    }

    public void exit() {
        JFrame frame = (JFrame)SwingUtilities.getRoot(this);
        frame.dispose();
        System.exit(0);
    }

    void showErrors(Object ... errors) {
        String[] messages = new String[errors.length];
        for (int i = 0; i < errors.length; ++i) {
            Object error = errors[i];
            messages[i] = error instanceof I18NError ? ((I18NError)((Object)error)).renderMessage(this.i18n) : ToStringConverter.convert((Object)error, (String)"null");
        }
        JOptionPane.showMessageDialog(this, messages, "Error", 0);
    }

    class TestConnectionListener
    implements ActionListener {
        TestConnectionListener() {
        }

        public void actionPerformed(ActionEvent actionevent) {
            try {
                Class.forName(CreateProjectPanel.this.setup.getDbDriver());
                DriverManager.getConnection(CreateProjectPanel.this.setup.getDbUrl(), CreateProjectPanel.this.setup.getDbUser(), CreateProjectPanel.this.setup.getDbPassword());
                JOptionPane.showMessageDialog(CreateProjectPanel.this, CreateProjectPanel.this.i18n.getString("message.connect.successful"));
            }
            catch (Exception e) {
                CreateProjectPanel.this.showErrors(e.toString());
            }
        }
    }

    class Creator
    implements Runnable {
        Creator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                CreateProjectPanel.this.createButton.setEnabled(false);
                String taskName = CreateProjectPanel.this.i18n.format("message.project.create", new Object[]{CreateProjectPanel.this.setup.getProjectName()});
                String message = CreateProjectPanel.this.i18n.getString("message.project.initializing");
                org.databene.gui.swing.ProgressMonitor monitor = new org.databene.gui.swing.ProgressMonitor(null, (Object)taskName, message, 0, 100);
                monitor.setMillisToDecideToPopup(10);
                monitor.setMillisToPopup(10);
                ArchetypeBuilder builder = new ArchetypeBuilder(CreateProjectPanel.this.setup, (ProgressMonitor)monitor);
                builder.run();
                String[] errors = builder.getErrors();
                if (errors.length > 0) {
                    CreateProjectPanel.this.showErrors(errors);
                } else {
                    JOptionPane.showMessageDialog(CreateProjectPanel.this, "Done");
                    CreateProjectPanel.this.exit();
                }
            }
            catch (I18NError e) {
                e.printStackTrace();
                CreateProjectPanel.this.showErrors(new Object[]{e});
            }
            catch (Exception e) {
                e.printStackTrace();
                CreateProjectPanel.this.showErrors(e);
            }
            finally {
                CreateProjectPanel.this.createButton.setEnabled(true);
                SwingUtil.repaintLater((Component)CreateProjectPanel.this);
            }
        }
    }

    class DBProjectListener
    implements ActionListener {
        DBProjectListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean useDB = CreateProjectPanel.this.dbProjectCheckBox.isSelected();
            CreateProjectPanel.this.dbUrlField.setEnabled(useDB);
            CreateProjectPanel.this.dbDriverField.setEnabled(useDB);
            CreateProjectPanel.this.dbUserField.setEnabled(useDB);
            CreateProjectPanel.this.dbSchemaField.setEnabled(useDB);
            CreateProjectPanel.this.dbPasswordField.setEnabled(useDB);
            CreateProjectPanel.this.dbSnapshotField.setEnabled(useDB);
            CreateProjectPanel.this.testButton.setEnabled(useDB);
        }
    }
}

