/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.gui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Locale;
import org.databene.benerator.gui.MavenDependency;
import org.databene.commons.FileUtil;
import org.databene.commons.LocaleUtil;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.StringUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.bean.ObservableBean;
import org.databene.commons.ui.I18NError;

public class Setup
implements ObservableBean {
    private static final String DEFAULT_PROJECT_NAME = "myproject";
    private static final String DEFAULT_GROUP_ID = "com.my";
    private static final String DEFAULT_PROJECT_VERSION = "1.0";
    private static final String DEFAULT_DB_URL = "jdbc:oracle:thin:@127.0.0.1:1521:XE";
    private static final String DEFAULT_DB_DRIVER = "oracle.jdbc.driver.OracleDriver";
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private String projectName;
    private String groupId;
    private String version;
    private File projectFolder = new File(SystemInfo.getCurrentDir());
    private boolean eclipseProject;
    private boolean offline;
    private boolean overwrite;
    private String encoding;
    private String lineSeparator;
    private String locale;
    private String dataset;
    private boolean databaseProject;
    private String dbUrl;
    private String dbDriver;
    private String dbPassword;
    private String dbSchema;
    private String dbUser;
    private String dbSnapshot;
    private MavenDependency[] dbDependencies;
    private File[] importFiles;

    public Setup() {
        this.setProjectName(DEFAULT_PROJECT_NAME);
        this.setGroupId(DEFAULT_GROUP_ID);
        this.setVersion(DEFAULT_PROJECT_VERSION);
        this.eclipseProject = true;
        this.offline = false;
        this.overwrite = false;
        this.setEncoding(SystemInfo.getFileEncoding());
        this.setLineSeparator(SystemInfo.getLineSeparator());
        this.setLocale(Locale.getDefault().toString());
        this.setDataset(LocaleUtil.getDefaultCountryCode());
        this.databaseProject = true;
        String url = System.getenv("DEFAULT_DATABASE");
        if (StringUtil.isEmpty((String)url)) {
            url = DEFAULT_DB_URL;
        }
        this.setDbUrl(url);
        this.setDbDriver(DEFAULT_DB_DRIVER);
        this.setDbUser(SystemInfo.getUserName());
        this.setDbSnapshot("DbUnit");
        this.importFiles = new File[0];
        this.dbDependencies = new MavenDependency[0];
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        String oldName = this.projectName;
        this.projectName = projectName;
        this.changeSupport.firePropertyChange("projectName", oldName, this.projectName);
        if (this.dbSchema == null || NullSafeComparator.equals((Object)oldName, (Object)this.dbUser)) {
            this.setDbUser(projectName);
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isEclipseProject() {
        return this.eclipseProject;
    }

    public void setEclipseProject(boolean eclipseProject) {
        boolean oldValue = this.eclipseProject;
        this.eclipseProject = eclipseProject;
        this.changeSupport.firePropertyChange("eclipseProject", oldValue, this.eclipseProject);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public void setProjectFolder(File projectFolder) {
        File oldValue = this.projectFolder;
        this.projectFolder = projectFolder;
        this.changeSupport.firePropertyChange("projectFolder", oldValue, this.projectFolder);
        if (DEFAULT_PROJECT_NAME.equals(this.projectName)) {
            this.setProjectName(projectFolder.getName());
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        String oldValue = this.encoding;
        this.encoding = encoding;
        this.changeSupport.firePropertyChange("encoding", oldValue, this.encoding);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        String oldValue = this.lineSeparator;
        this.lineSeparator = lineSeparator;
        this.changeSupport.firePropertyChange("lineSeparator", oldValue, this.lineSeparator);
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        String oldValue = this.locale;
        this.locale = locale;
        this.changeSupport.firePropertyChange("locale", oldValue, this.locale);
    }

    public String getDataset() {
        return this.dataset;
    }

    public void setDataset(String dataset) {
        String oldValue = this.dataset;
        this.dataset = dataset;
        this.changeSupport.firePropertyChange("dataset", oldValue, this.dataset);
    }

    public boolean isDatabaseProject() {
        return this.databaseProject;
    }

    public void setDatabaseProject(boolean databaseProject) {
        boolean oldValue = this.databaseProject;
        this.databaseProject = databaseProject;
        this.changeSupport.firePropertyChange("databaseProject", oldValue, this.databaseProject);
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        String oldValue = this.dbUrl;
        this.dbUrl = dbUrl;
        this.changeSupport.firePropertyChange("dbUrl", oldValue, this.dbUrl);
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public void setDbDriver(String dbDriver) {
        String oldValue = this.dbDriver;
        this.dbDriver = dbDriver;
        this.changeSupport.firePropertyChange("dbDriver", oldValue, this.dbDriver);
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        String oldValue = this.dbPassword;
        this.dbPassword = dbPassword;
        this.changeSupport.firePropertyChange("dbPassword", oldValue, this.dbPassword);
    }

    public String getDbSchema() {
        return this.dbSchema;
    }

    public void setDbSchema(String dbSchema) {
        String oldValue = this.dbSchema;
        this.dbSchema = dbSchema;
        this.changeSupport.firePropertyChange("dbSchema", oldValue, this.dbSchema);
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        String oldValue = this.dbUser;
        this.dbUser = dbUser;
        this.changeSupport.firePropertyChange("dbUser", oldValue, this.dbUser);
        if (this.dbSchema == null || NullSafeComparator.equals((Object)oldValue, (Object)this.dbSchema)) {
            this.setDbSchema(dbUser);
        }
        if (this.dbPassword == null || NullSafeComparator.equals((Object)oldValue, (Object)this.dbPassword)) {
            this.setDbPassword(dbUser);
        }
    }

    public MavenDependency[] getDbDependencies() {
        return this.dbDependencies;
    }

    public void setDbDependencies(MavenDependency[] dbDependencies) {
        this.dbDependencies = dbDependencies;
    }

    public String getDbSnapshot() {
        return this.dbSnapshot;
    }

    public void setDbSnapshot(String dbSnapshot) {
        this.dbSnapshot = dbSnapshot;
    }

    public File[] getImportFiles() {
        return this.importFiles;
    }

    public void setImportFiles(File ... importFiles) {
        File[] oldValue = this.importFiles;
        this.importFiles = importFiles;
        this.changeSupport.firePropertyChange("importFiles", oldValue, this.importFiles);
    }

    public void addImportFile(File importFile) {
        File[] oldValue = this.importFiles;
        this.importFiles = new File[oldValue.length + 1];
        System.arraycopy(oldValue, 0, this.importFiles, 0, oldValue.length);
        this.importFiles[this.importFiles.length - 1] = importFile;
        this.changeSupport.firePropertyChange("importFiles", oldValue, this.importFiles);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public File projectFile(String filename) {
        File file = new File(this.getProjectFolder(), filename);
        if (!this.overwrite && file.exists()) {
            throw new I18NError("FileAlreadyExists", null, new Object[]{filename});
        }
        return file;
    }

    public File subDirectory(String relativePath) {
        return new File(this.projectFolder, FileUtil.nativePath((String)relativePath));
    }
}

