/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.main;

import java.io.IOException;
import java.util.List;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.engine.DescriptorRunner;
import org.databene.commons.SystemInfo;
import org.databene.commons.VMInfo;
import org.databene.commons.ui.ConsoleInfoPrinter;
import org.databene.model.version.VersionNumber;

public class Benerator {
    public static final String LOCALE_VM_PARAM = "benerator.locale";
    private static final Log logger = LogFactory.getLog(Benerator.class);
    private static final Log configLogger = LogFactory.getLog((String)"org.databene.CONFIG");

    public static void main(String[] args) throws IOException {
        String filename = args.length > 0 ? args[0] : "benerator.xml";
        configLogger.debug((Object)("Running benerator with file " + filename));
        Benerator.checkSystem();
        Benerator.listScriptEngines();
        new DescriptorRunner(filename).run();
    }

    private static void listScriptEngines() {
        ScriptEngineManager mgr = new ScriptEngineManager();
        List<ScriptEngineFactory> engineFactories = mgr.getEngineFactories();
        if (engineFactories.size() > 0) {
            configLogger.debug((Object)"Installed JSR 223 Script Engines:");
            for (ScriptEngineFactory engineFactory : engineFactories) {
                configLogger.debug((Object)("- " + engineFactory.getEngineName() + engineFactory.getNames()));
            }
        }
    }

    private static void checkSystem() {
        configLogger.debug((Object)("Java " + VMInfo.getJavaVersion()));
        configLogger.debug((Object)(VMInfo.getJavaVmName() + " " + VMInfo.getJavaVmVersion() + " (" + VMInfo.getJavaVmVendor() + ")"));
        configLogger.debug((Object)(SystemInfo.getOsName() + " " + SystemInfo.getOsVersion() + " (" + SystemInfo.getOsArchitecture() + ")"));
        try {
            Class.forName("javax.script.ScriptEngine");
        }
        catch (ClassNotFoundException e) {
            ConsoleInfoPrinter.printHelp((String[])new String[]{"You need to run benerator with Java 6 or greater!"});
            if (SystemInfo.isMacOsx()) {
                ConsoleInfoPrinter.printHelp((String[])new String[]{"Please check the reference manual for Java setup on Mac OS X."});
            }
            System.exit(-1);
        }
        VersionNumber javaVersion = new VersionNumber(VMInfo.getJavaVersion());
        if (javaVersion.compareTo(new VersionNumber("1.6")) < 0) {
            logger.warn((Object)"benerator is written for and tested under Java 6 - you managed to set up JSR 226, but may face other problems.");
        }
    }
}

