/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.databene.benerator.gui.CreateProjectPanel;
import org.databene.benerator.gui.Setup;
import org.databene.commons.StringUtil;
import org.databene.commons.ui.I18NSupport;

public class BeneratorGUI
extends JFrame {
    private static final long serialVersionUID = -5866303491038671990L;

    public BeneratorGUI() {
        this.setIcons("org/databene/benerator/gui/benerator{0}.png", 16, 32, 64, 128);
        this.checkLocale();
        I18NSupport bundle = new I18NSupport("org/databene/benerator/gui/benerator", Locale.getDefault());
        Setup setup = new Setup();
        this.setTitle(bundle.getString("beneratorGuiTitle"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)new CreateProjectPanel(setup, bundle), "Center");
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void setIcons(String pattern, int ... sizes) {
        ArrayList<Image> images = new ArrayList<Image>();
        for (int size : sizes) {
            String name = MessageFormat.format(pattern, size);
            images.add(new ImageIcon(name).getImage());
        }
        this.setIconImages(images);
    }

    private void checkLocale() {
        String localeCode = System.getProperty("benerator.locale");
        if (!StringUtil.isEmpty((String)localeCode)) {
            Locale.setDefault(new Locale(localeCode));
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        new BeneratorGUI().setVisible(true);
    }
}

