/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.main;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.NumberUtil;
import org.databene.commons.RoundedNumberFormat;
import org.databene.commons.StringUtil;
import org.databene.commons.ui.ProgressMonitor;
import org.databene.model.data.Entity;
import org.databene.model.data.TypeDescriptor;
import org.databene.platform.db.DBSystem;
import org.databene.platform.dbunit.DbUnitEntityExporter;

public class DBSnapshotTool {
    public static final String DB_PASSWORD = "dbPassword";
    public static final String DB_URL = "dbUrl";
    public static final String DB_DRIVER = "dbDriver";
    public static final String DB_SCHEMA = "dbSchema";
    public static final String DB_USER = "dbUser";
    private static final Log logger = LogFactory.getLog(DBSnapshotTool.class);

    public static void main(String[] args) {
        logger.info((Object)("Starting " + DBSnapshotTool.class.getSimpleName()));
        String filename = args.length > 0 ? args[0] : "snapshot.dbunit.xml";
        String dbUrl = System.getProperty(DB_URL);
        if (StringUtil.isEmpty((String)dbUrl)) {
            throw new IllegalArgumentException("No database URL specified. Please provide the JDBC URL as an environment property like '-DdbUrl=jdbc:...'");
        }
        String dbDriver = System.getProperty(DB_DRIVER);
        if (StringUtil.isEmpty((String)dbDriver)) {
            throw new IllegalArgumentException("No database driver specified. Please provide the JDBC driver class name as an environment property like '-DdbDriver=...'");
        }
        String dbUser = System.getProperty(DB_USER);
        String dbPassword = System.getProperty(DB_PASSWORD);
        String dbSchema = System.getProperty(DB_SCHEMA);
        logger.info((Object)("Exporting data of database '" + dbUrl + "' with driver '" + dbDriver + "' as user '" + dbUser + "'" + (dbSchema != null ? " using schema '" + dbSchema + "'" : "") + " to file " + filename));
        DBSnapshotTool.export(dbUrl, dbDriver, dbSchema, dbUser, dbPassword, filename, null);
    }

    public static void export(String dbUrl, String dbDriver, String dbSchema, String dbUser, String dbPassword, String filename) {
        DBSnapshotTool.export(dbUrl, dbDriver, dbSchema, dbUser, dbPassword, filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(String dbUrl, String dbDriver, String dbSchema, String dbUser, String dbPassword, String filename, ProgressMonitor monitor) {
        if (dbUser == null) {
            logger.warn((Object)"No JDBC user specified");
        }
        String fileEncoding = System.getProperty("file.encoding");
        long startTime = System.currentTimeMillis();
        DbUnitEntityExporter exporter = new DbUnitEntityExporter(filename, fileEncoding);
        DBSystem db = null;
        int count = 0;
        try {
            db = new DBSystem("db", dbUrl, dbDriver, dbUser, dbPassword);
            if (dbSchema != null) {
                db.setSchema(dbSchema);
            }
            db.setDynamicQuerySupported(false);
            List<TypeDescriptor> descriptors = Arrays.asList(db.getTypeDescriptors());
            logger.info((Object)"Starting export");
            for (TypeDescriptor descriptor : descriptors) {
                String note = "Exporting table " + descriptor.getName();
                if (monitor != null) {
                    monitor.setNote(note);
                    if (monitor.isCanceled()) {
                        throw new RuntimeException("Export cancelled");
                    }
                }
                logger.info((Object)note);
                Thread.yield();
                for (Entity entity : db.queryEntities(descriptor.getName(), null, null)) {
                    exporter.startConsuming(entity);
                    exporter.finishConsuming(entity);
                    ++count;
                }
                if (monitor == null) continue;
                monitor.advance();
            }
            long duration = System.currentTimeMillis() - startTime;
            logger.info((Object)("Exported " + NumberUtil.format((double)count, (int)0) + " entities in " + RoundedNumberFormat.format((Number)duration, (int)0) + " ms (" + RoundedNumberFormat.format((Number)((long)count * 3600000L / duration), (int)0) + " p.h.)"));
        }
        finally {
            exporter.close();
            if (db != null) {
                db.close();
            }
        }
    }
}

