/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.main;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.file.XMLFileGenerator;
import org.databene.commons.ArrayUtil;
import org.databene.commons.ui.ConsoleInfoPrinter;

public class XmlCreator {
    private static final Log logger = LogFactory.getLog(XmlCreator.class);

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            XmlCreator.printHelp();
            System.exit(-1);
        }
        String schemaUri = args[0];
        String root = args[1];
        String pattern = args[2];
        long fileCount = Long.parseLong(args[3]);
        String[] propertiesFiles = args.length > 4 ? (String[])ArrayUtil.copyOfRange((Object[])args, (int)4, (int)(args.length - 4)) : new String[]{};
        XmlCreator.createXMLFiles(schemaUri, root, pattern, fileCount, propertiesFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createXMLFiles(String schemaUri, String root, String pattern, long fileCount, String[] propertiesFiles) throws IOException {
        XmlCreator.logParams(schemaUri, root, pattern, fileCount);
        long start = System.currentTimeMillis();
        XMLFileGenerator fileGenerator = new XMLFileGenerator(schemaUri, root, pattern, propertiesFiles);
        try {
            for (long i = 0L; i < fileCount && fileGenerator.available(); ++i) {
                File file = fileGenerator.generate();
                logger.info((Object)("created file: " + file));
            }
        }
        finally {
            fileGenerator.close();
        }
        long duration = System.currentTimeMillis() - start;
        logger.info((Object)("Finished after " + duration + " ms"));
    }

    private static void logParams(String schemaUri, String root, String pattern, long fileCount) {
        if (logger.isDebugEnabled()) {
            if (fileCount > 1L) {
                logger.debug((Object)("Creating " + fileCount + " XML files for schema " + schemaUri + " with root " + root + " and pattern " + pattern));
            } else {
                logger.debug((Object)("Creating XML file " + MessageFormat.format(pattern, fileCount) + " for schema " + schemaUri + " with root " + root));
            }
        }
    }

    private static void printHelp() {
        ConsoleInfoPrinter.printHelp((String[])new String[]{"Invalid parameters", "parameters: schemaUri root fileNamePattern count [propertiesFilenames]"});
    }
}

