/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.parser;

import java.util.BitSet;
import org.databene.benerator.parser.BeanPropertyConstruction;
import org.databene.benerator.parser.Construction;
import org.databene.benerator.parser.Expression;
import org.databene.benerator.parser.Invocation;
import org.databene.benerator.parser.ParametrizedConstruction;
import org.databene.benerator.parser.Reference;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.ParseException;
import org.databene.commons.StringCharacterIterator;
import org.databene.commons.StringUtil;
import org.databene.commons.bean.ClassProvider;
import org.databene.commons.converter.LiteralParser;

public class BasicParser {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Object NOT_AN_ELEMENT = new Object();
    private BitSet nameCharacters;

    public BasicParser() {
        this.initNameCharacters();
    }

    public void addNameCharacter(char c) {
        this.nameCharacters.set(c);
    }

    public Invocation parseInvocation(String code) throws ParseException {
        StringCharacterIterator iterator = new StringCharacterIterator(code);
        String fqName = this.parseFullyQualifiedName(iterator);
        iterator.skipWhitespace();
        Object[] params = this.parseInvocationParameters(iterator);
        params = this.preprocessParams(params);
        return new Invocation(fqName, params);
    }

    public Object resolveConstructionOrReference(String text, ClassProvider classProvider, Context context) throws ParseException {
        return this.resolveConstructionOrReference(new StringCharacterIterator(text), classProvider, context);
    }

    public Object resolveConstructionOrReference(StringCharacterIterator iterator, ClassProvider classProvider, Context context) throws ParseException {
        Expression expression = this.parseConstructionOrReference(iterator, classProvider, context);
        return expression.evaluate();
    }

    public Expression parseConstructionOrReference(StringCharacterIterator iterator, ClassProvider classProvider, Context context) throws ParseException {
        Object ref;
        String classNameOrRef = this.parseFullyQualifiedName(iterator);
        iterator.skipWhitespace();
        if (context != null && (ref = context.get(classNameOrRef)) != null) {
            return new Reference(classNameOrRef, context);
        }
        return this.parseConstructionDetails(iterator, classNameOrRef, classProvider);
    }

    public Construction parseConstruction(String code, ClassProvider classProvider, Context context) throws ParseException {
        StringCharacterIterator iterator = new StringCharacterIterator(code);
        String className = this.parseFullyQualifiedName(iterator);
        iterator.skipWhitespace();
        return this.parseConstructionDetails(iterator, className, classProvider);
    }

    private Construction parseConstructionDetails(StringCharacterIterator iterator, String className, ClassProvider classProvider) {
        if (!iterator.hasNext()) {
            return new Construction(className, classProvider);
        }
        char next = iterator.peekNext();
        if (next == '(') {
            Object[] params = this.parseConstructorParams(iterator);
            if (params.length > 0) {
                return new ParametrizedConstruction(className, classProvider, params);
            }
            return new Construction(className, classProvider);
        }
        if (next == '[') {
            return this.parseBeanProperties(className, iterator, classProvider);
        }
        throw new ParseException("Unexpected character: " + next, 1, iterator.index());
    }

    private BeanPropertyConstruction parseBeanProperties(String className, StringCharacterIterator iterator, ClassProvider classProvider) {
        BeanPropertyConstruction construction = new BeanPropertyConstruction(className, classProvider);
        iterator.assertNext('[');
        Object[] properties = BasicParser.parseCommaSeparatedList(iterator, ',', ']');
        iterator.assertNext(']');
        for (Object prop : properties) {
            String propertyDef = (String)prop;
            int eq = propertyDef.indexOf(61);
            if (eq < 0) {
                throw new ConfigurationError("Assignment missing for property definition: " + propertyDef);
            }
            String propertyName = propertyDef.substring(0, eq).trim();
            Object propertyValue = this.unquote(propertyDef.substring(eq + 1).trim());
            construction.addProperty(propertyName, propertyValue);
        }
        return construction;
    }

    private Object[] parseConstructorParams(StringCharacterIterator iterator) {
        Object[] parameters = this.parseInvocationParameters(iterator);
        return this.preprocessParams(parameters);
    }

    public String parseFullyQualifiedName(StringCharacterIterator iterator) {
        int start = iterator.index();
        boolean done = false;
        do {
            String namePart;
            if (!(done = StringUtil.isEmpty((String)(namePart = this.parseName(iterator))))) {
                boolean bl = done = iterator.peekNext() != '.';
            }
            if (done) continue;
            iterator.next();
        } while (!done);
        return iterator.parsedSubstring(start);
    }

    public String parseName(StringCharacterIterator iterator) {
        int start = iterator.index();
        while (iterator.hasNext() && this.isNameCharacter(iterator.peekNext())) {
            iterator.next();
        }
        return iterator.parsedSubstring(start);
    }

    public boolean isNameCharacter(char c) {
        if (c >= '\u0100') {
            return false;
        }
        return this.nameCharacters.get(c);
    }

    public static Object[] parseSeparatedList(String text, char separator) {
        if (StringUtil.isEmpty((String)(text = StringUtil.trim((String)text)))) {
            return EMPTY_ARRAY;
        }
        StringCharacterIterator iterator = new StringCharacterIterator(text);
        return BasicParser.parseCommaSeparatedList(iterator, separator, '\u0000');
    }

    private void initNameCharacters() {
        int c;
        this.nameCharacters = new BitSet(256);
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            this.nameCharacters.set(c);
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            this.nameCharacters.set(c);
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            this.nameCharacters.set(c);
        }
        this.nameCharacters.set(95);
        this.nameCharacters.set(36);
    }

    private static Object[] parseCommaSeparatedList(StringCharacterIterator iterator, char separator, char rightParenthesis) {
        Object element;
        int start;
        ArrayBuilder builder = new ArrayBuilder(Object.class);
        int lastNonWs = start = iterator.index();
        char quoteMode = BasicParser.leadingQuote(iterator);
        boolean escapeOccurred = false;
        boolean escapeMode = false;
        while (iterator.hasNext()) {
            char c = iterator.next();
            if (!(c != separator && c != rightParenthesis || quoteMode != '\u0000' || escapeMode)) {
                Object element2 = BasicParser.formatListElement(iterator, start, lastNonWs, escapeOccurred, escapeMode);
                if (!NOT_AN_ELEMENT.equals(element2)) {
                    builder.append(element2);
                }
                iterator.skipWhitespace();
                start = iterator.index();
                escapeOccurred = false;
                if (c != rightParenthesis) continue;
                iterator.pushBack();
                break;
            }
            if (c == '\\' && !escapeMode) {
                escapeOccurred = true;
                escapeMode = true;
            } else if (escapeMode) {
                escapeMode = false;
            } else if (BasicParser.isQuote(c)) {
                if (quoteMode == c) {
                    quoteMode = '\u0000';
                } else if (quoteMode == '\u0000') {
                    quoteMode = c;
                }
            }
            if (Character.isWhitespace(c)) continue;
            lastNonWs = iterator.index();
        }
        if (start < iterator.index() && !NOT_AN_ELEMENT.equals(element = BasicParser.formatListElement(iterator, start, lastNonWs, escapeOccurred, escapeMode))) {
            builder.append(element);
        }
        return builder.toArray();
    }

    private Object[] parseInvocationParameters(StringCharacterIterator iterator) {
        iterator.assertNext('(');
        Object[] parsedParameters = BasicParser.parseCommaSeparatedList(iterator, ',', ')');
        iterator.assertNext(')');
        return parsedParameters;
    }

    private Object[] preprocessParams(Object[] parsedParams) {
        Object[] result = new Object[parsedParams.length];
        for (int i = 0; i < parsedParams.length; ++i) {
            result[i] = this.unquote(parsedParams[i]);
        }
        return result;
    }

    private Object unquote(Object value) {
        String string;
        if (value instanceof String && ((string = (String)value).startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\""))) {
            return string.substring(1, string.length() - 1);
        }
        return value;
    }

    private static Object formatListElement(StringCharacterIterator iterator, int from, int to, boolean escapeOccurred, boolean escapeModeActive) {
        if (escapeModeActive) {
            throw new IllegalStateException("Token ended in escape mode");
        }
        if (from == to) {
            return NOT_AN_ELEMENT;
        }
        Object result = LiteralParser.parse((String)iterator.substring(from, to));
        if (result instanceof String) {
            if (((String)(result = ((String)result).trim())).length() == 0) {
                return NOT_AN_ELEMENT;
            }
            if (escapeOccurred) {
                result = StringUtil.unescape((String)((String)result));
            }
        }
        return result;
    }

    private static char leadingQuote(StringCharacterIterator iterator) {
        if (!iterator.hasNext()) {
            return '\u0000';
        }
        char c = iterator.next();
        if (BasicParser.isQuote(c)) {
            return c;
        }
        iterator.pushBack();
        return '\u0000';
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    public static Object parseLiteral(String text) {
        return LiteralParser.parse((String)text);
    }
}

