/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.parser;

import java.util.Map;
import org.databene.benerator.engine.BeneratorContext;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;
import org.databene.commons.collection.MapEntry;
import org.databene.commons.converter.FixedSourceTypeConverter;
import org.databene.commons.converter.LiteralParser;
import org.databene.commons.converter.NoOpConverter;
import org.databene.commons.mutator.AnyMutator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEntryConverter
extends FixedSourceTypeConverter<Map.Entry, Map.Entry> {
    private BeneratorContext context;
    private Converter<String, Object> preprocessor;
    private LiteralParser stringParser;
    private boolean putEntriesToContext;

    public DefaultEntryConverter(BeneratorContext context) {
        this((Converter<String, Object>)new NoOpConverter(), context, false);
    }

    public DefaultEntryConverter(Converter<String, Object> preprocessor, BeneratorContext context, boolean putEntriesToContext) {
        super(Map.Entry.class, Map.Entry.class);
        this.preprocessor = preprocessor;
        this.context = context;
        this.putEntriesToContext = putEntriesToContext;
        this.stringParser = new LiteralParser();
    }

    public Map.Entry convert(Map.Entry entry) throws ConversionException {
        String key = String.valueOf(entry.getKey());
        String sourceValue = String.valueOf(entry.getValue());
        sourceValue = String.valueOf(this.preprocessor.convert((Object)sourceValue));
        Object result = this.stringParser.convert(sourceValue);
        if (this.putEntriesToContext) {
            if (key.startsWith("benerator.")) {
                AnyMutator.setValue((Object)((Object)this.context), (String)key, (Object)result, (boolean)true);
            } else {
                this.context.setProperty(key, result);
            }
        }
        return new MapEntry((Object)key, result);
    }
}

