/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.parser;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.Generator;
import org.databene.benerator.engine.BeneratorContext;
import org.databene.benerator.parser.BasicParser;
import org.databene.benerator.parser.Construction;
import org.databene.benerator.parser.DefaultEntryConverter;
import org.databene.benerator.parser.xml.XmlDescriptorParser;
import org.databene.commons.ArrayFormat;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.Converter;
import org.databene.commons.IOUtil;
import org.databene.commons.StringUtil;
import org.databene.commons.bean.ClassProvider;
import org.databene.commons.converter.ToStringConverter;
import org.databene.commons.xml.XMLElement2BeanConverter;
import org.databene.commons.xml.XMLUtil;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.DataModel;
import org.databene.model.data.Entity;
import org.databene.model.data.EntitySource;
import org.databene.model.data.FeatureDescriptor;
import org.databene.model.data.IdDescriptor;
import org.databene.model.data.InstanceDescriptor;
import org.databene.model.data.PartDescriptor;
import org.databene.model.data.ReferenceDescriptor;
import org.databene.model.data.SimpleTypeDescriptor;
import org.databene.model.data.TypeDescriptor;
import org.databene.script.ScriptConverter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelParser {
    private static final Log logger = LogFactory.getLog(ModelParser.class);
    private BeneratorContext context;
    private BasicParser basicParser;

    public ModelParser(BeneratorContext context) {
        this.context = context;
        this.basicParser = new BasicParser();
    }

    public Object parseBean(Element element) {
        String beanId = XmlDescriptorParser.parseStringAttribute(element, "id", (Context)this.context);
        String beanClass = XmlDescriptorParser.parseStringAttribute(element, "class", (Context)this.context);
        String beanSpec = XmlDescriptorParser.parseStringAttribute(element, "spec", (Context)this.context);
        if (beanClass != null) {
            logger.debug((Object)("Instantiating bean of class " + beanClass + " (id=" + beanId + ")"));
            Object bean = XMLElement2BeanConverter.convert((Element)element, (Context)this.context, (Converter)new ScriptConverter((Context)this.context), (ClassProvider)this.context);
            if (!StringUtil.isEmpty((String)beanId)) {
                BeanUtil.setPropertyValue((Object)bean, (String)"id", (Object)beanId, (boolean)false);
                this.context.set(beanId, bean);
            }
            return bean;
        }
        if (beanSpec != null) {
            logger.debug((Object)("Instantiating bean: " + beanSpec + " (id=" + beanId + ")"));
            Construction construction = this.basicParser.parseConstruction(beanSpec, this.context, (Context)this.context);
            return construction.evaluate();
        }
        throw new ConfigurationError("Syntax error in definition of bean " + beanId);
    }

    public ComponentDescriptor parseSimpleTypeComponent(Element element, ComplexTypeDescriptor owner) {
        return this.parseSimpleTypeComponent(element, owner, null);
    }

    public ComponentDescriptor parseSimpleTypeComponent(Element element, ComplexTypeDescriptor owner, ComponentDescriptor descriptor) {
        String name = XMLUtil.localName((Element)element);
        if ("part".equals(name) || "attribute".equals(name)) {
            return this.parsePart(element, owner, false, descriptor);
        }
        if ("id".equals(name)) {
            return this.parseId(element, descriptor);
        }
        if ("reference".equals(name)) {
            return this.parseReference(element, descriptor);
        }
        throw new ConfigurationError("Expected one of these element names: 'id', 'attribute', 'reference' or 'part'. Found: " + name);
    }

    public ComplexTypeDescriptor parseComplexType(Element ctElement, ComplexTypeDescriptor descriptor) {
        this.assertElementName(ctElement, "entity", "type");
        descriptor = new ComplexTypeDescriptor(descriptor.getName(), descriptor);
        this.mapTypeDetails(ctElement, descriptor);
        for (Element child : XMLUtil.getChildElements((Element)ctElement)) {
            this.parseComplexTypeChild(child, descriptor);
        }
        return descriptor;
    }

    public void parseComplexTypeChild(Element element, ComplexTypeDescriptor descriptor) {
        String childName = XMLUtil.localName((Element)element);
        if (!"variable".equals(childName)) {
            throw new UnsupportedOperationException("element type not supported here: " + childName);
        }
        this.parseVariable(element, descriptor);
    }

    public PartDescriptor parsePart(Element element, ComplexTypeDescriptor owner, boolean complex, ComponentDescriptor descriptor) {
        ComponentDescriptor parentComponent;
        PartDescriptor result;
        this.assertElementName(element, "part", "attribute");
        if (descriptor instanceof PartDescriptor) {
            result = (PartDescriptor)descriptor;
        } else if (descriptor != null) {
            result = new PartDescriptor(descriptor.getName(), descriptor.getTypeName());
        } else {
            String type = this.normalizeNull(element.getAttribute("type"));
            result = new PartDescriptor(element.getAttribute("name"), type);
        }
        this.mapInstanceDetails(element, complex, result);
        if (result.getDeclaredDetailValue("minCount") == null) {
            result.setDetailValue("minCount", 1);
        }
        if (result.getDeclaredDetailValue("maxCount") == null) {
            result.setDetailValue("maxCount", 1);
        }
        if (owner != null && (parentComponent = owner.getComponent(result.getName())) != null) {
            TypeDescriptor parentType = parentComponent.getType();
            result.getLocalType(false).setParent(parentType);
        }
        return result;
    }

    public SimpleTypeDescriptor parseSimpleType(Element element) {
        this.assertElementName(element, "type");
        return this.parseSimpleType(element, new SimpleTypeDescriptor(null, (String)null));
    }

    public SimpleTypeDescriptor parseSimpleType(Element element, SimpleTypeDescriptor descriptor) {
        this.assertElementName(element, "type");
        return this.mapTypeDetails(element, descriptor);
    }

    public InstanceDescriptor parseVariable(Element varElement, ComplexTypeDescriptor parent) {
        this.assertElementName(varElement, "variable");
        InstanceDescriptor descriptor = new InstanceDescriptor(varElement.getAttribute("name"));
        InstanceDescriptor variable = this.mapInstanceDetails(varElement, false, descriptor);
        parent.addVariable(variable);
        return variable;
    }

    public String parseInclude(Element element) {
        String uri = XmlDescriptorParser.parseStringAttribute(element, "uri", (Context)this.context);
        uri = IOUtil.resolveLocalUri((String)uri, (String)this.context.getContextUri());
        try {
            this.importProperties(uri);
            return uri;
        }
        catch (IOException e) {
            throw new ConfigurationError("Properties file not found for uri: " + uri);
        }
    }

    public void importProperties(String uri) throws IOException {
        logger.debug((Object)("reading properties from uri: " + uri));
        ScriptConverter preprocessor = new ScriptConverter((Context)this.context);
        DefaultEntryConverter converter = new DefaultEntryConverter((Converter<String, Object>)preprocessor, this.context, true);
        IOUtil.readProperties((String)uri, (Converter)converter);
    }

    private <T extends TypeDescriptor> T mapTypeDetails(Element element, T descriptor) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String detailValue = XmlDescriptorParser.parseStringAttribute(attr, (Context)this.context);
            ((FeatureDescriptor)descriptor).setDetailValue(attr.getName(), (String)detailValue);
        }
        return (T)descriptor;
    }

    private <T extends InstanceDescriptor> T mapInstanceDetails(Element element, boolean complexType, T descriptor) {
        TypeDescriptor localType = ((InstanceDescriptor)descriptor).getLocalType();
        Map attributes = XMLUtil.getAttributes((Element)element);
        for (Map.Entry entry : attributes.entrySet()) {
            String detailName = (String)entry.getKey();
            if (detailName.equals("type")) continue;
            Object tmp = XmlDescriptorParser.renderAttribute(detailName, (String)entry.getValue(), (Context)this.context);
            String detailString = ToStringConverter.convert((Object)tmp, null);
            if (((FeatureDescriptor)descriptor).supportsDetail(detailName)) {
                ((FeatureDescriptor)descriptor).setDetailValue(detailName, (String)detailString);
                continue;
            }
            if (localType == null) {
                String sourceSpec;
                String partType = (String)attributes.get("type");
                if (partType == null) {
                    partType = ((InstanceDescriptor)descriptor).getTypeName();
                }
                if (partType == null && (sourceSpec = (String)attributes.get("source")) != null) {
                    Object source = this.context.get(sourceSpec);
                    if (source != null) {
                        if (source instanceof Generator) {
                            if (((Generator)source).getGeneratedType() == Entity.class) {
                                partType = "entity";
                            }
                        } else if (source instanceof EntitySource) {
                            partType = "entity";
                        }
                    } else if (sourceSpec.endsWith(".ent.csv") || sourceSpec.endsWith(".flat.csv") || sourceSpec.endsWith(".dbunit.xml")) {
                        partType = "entity";
                    }
                }
                if (partType != null) {
                    TypeDescriptor localTypeParent = DataModel.getDefaultInstance().getTypeDescriptor(partType);
                    String name = (String)attributes.get("name");
                    localType = localTypeParent instanceof ComplexTypeDescriptor ? new ComplexTypeDescriptor(name, partType) : new SimpleTypeDescriptor(name, partType);
                }
                ((InstanceDescriptor)descriptor).setLocalType(localType);
            }
            if (localType == null) {
                localType = ((InstanceDescriptor)descriptor).getLocalType(complexType);
            }
            localType.setDetailValue(detailName, detailString);
        }
        return (T)descriptor;
    }

    private void assertElementName(Element element, String ... expectedNames) {
        String elementName = XMLUtil.localName((Element)element);
        for (String expectedName : expectedNames) {
            if (!elementName.equals(expectedName)) continue;
            return;
        }
        String message = expectedNames.length == 1 ? "Expected element '" + expectedNames[0] + "', found: " + elementName : "Expected one of these element names: '" + ArrayFormat.format((Object[])expectedNames) + "', " + "found: " + elementName;
        throw new IllegalArgumentException(message);
    }

    private String normalizeNull(String text) {
        return "".equals(text) ? null : text;
    }

    private IdDescriptor parseId(Element element, ComponentDescriptor descriptor) {
        this.assertElementName(element, "id");
        IdDescriptor result = descriptor instanceof IdDescriptor ? (IdDescriptor)descriptor : (descriptor != null ? new IdDescriptor(descriptor.getName(), descriptor.getTypeName()) : new IdDescriptor(element.getAttribute("name"), element.getAttribute("type")));
        return this.mapInstanceDetails(element, false, result);
    }

    private ReferenceDescriptor parseReference(Element element, ComponentDescriptor descriptor) {
        this.assertElementName(element, "reference");
        ReferenceDescriptor result = descriptor instanceof ReferenceDescriptor ? (ReferenceDescriptor)descriptor : (descriptor != null ? new ReferenceDescriptor(descriptor.getName(), descriptor.getTypeName()) : new ReferenceDescriptor(element.getAttribute("name"), element.getAttribute("type")));
        return this.mapInstanceDetails(element, false, result);
    }

    public void parseImport(Element element) {
        String attribute = element.getAttribute("class");
        if (!StringUtil.isEmpty((String)attribute)) {
            this.context.importClass(attribute);
        }
        if (!StringUtil.isEmpty((String)(attribute = element.getAttribute("domain")))) {
            this.importDomain(attribute);
        }
        if ("true".equals(element.getAttribute("defaults"))) {
            this.context.importDefaults();
        }
    }

    public void importDomain(String domain) {
        if (domain.indexOf(46) < 0) {
            this.context.importPackage("org.databene.domain." + domain);
        } else {
            this.context.importPackage(domain);
        }
    }
}

