/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.parser.xml;

import org.databene.commons.Context;
import org.databene.commons.StringUtil;
import org.databene.commons.converter.AnyConverter;
import org.databene.commons.converter.ToStringConverter;
import org.databene.script.ScriptUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class XmlDescriptorParser {
    private XmlDescriptorParser() {
    }

    public static String parseStringAttribute(Element element, String name, Context context) {
        Object value = XmlDescriptorParser.parseAttribute(element, name, context);
        return StringUtil.unescape((String)ToStringConverter.convert((Object)value, null));
    }

    public static String parseStringAttribute(Attr attribute, Context context) {
        Object value = XmlDescriptorParser.renderAttribute(attribute.getName(), attribute.getValue(), context);
        return StringUtil.unescape((String)ToStringConverter.convert((Object)value, null));
    }

    public static int parseIntAttribute(Element element, String name, Context context, int defaultValue) {
        Object value = XmlDescriptorParser.parseAttribute(element, name, context);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value == null || value instanceof String && StringUtil.isEmpty((String)((String)value))) {
            return defaultValue;
        }
        return (Integer)AnyConverter.convert((Object)value, Integer.class);
    }

    public static long parseLongAttribute(Element element, String name, Context context, long defaultValue) {
        Object value = XmlDescriptorParser.parseAttribute(element, name, context);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value == null || value instanceof String && StringUtil.isEmpty((String)((String)value))) {
            return defaultValue;
        }
        return (Long)AnyConverter.convert((Object)value, Long.class);
    }

    public static boolean parseBooleanAttribute(Element element, String name, Context context, boolean defaultValue) {
        Object value = XmlDescriptorParser.parseAttribute(element, name, context);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null || value instanceof String && StringUtil.isEmpty((String)((String)value))) {
            return defaultValue;
        }
        return (Boolean)AnyConverter.convert((Object)value, Boolean.class);
    }

    public static Object parseAttribute(Element element, String name, Context context) {
        String value = element.getAttribute(name);
        if (value != null && value.length() == 0) {
            value = null;
        }
        return XmlDescriptorParser.renderAttribute(name, value, context);
    }

    public static Object parseAttribute(Attr attribute, Context context) {
        String name = attribute.getName();
        String value = attribute.getValue();
        return XmlDescriptorParser.renderAttribute(name, value, context);
    }

    public static Object renderAttribute(String name, String value, Context context) {
        if (value == null || "script".equals(name)) {
            return value;
        }
        return ScriptUtil.render((String)value, (Context)context);
    }
}

