/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.sample.WeightedSampleGenerator;
import org.databene.commons.LocaleUtil;
import org.databene.regex.RegexParser;
import org.databene.regex.RegexTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterGenerator
implements Generator<Character> {
    private String pattern;
    private Locale locale;
    private Set<Character> values;
    private boolean dirty;
    private WeightedSampleGenerator<Character> source;

    public CharacterGenerator() {
        this("\\w");
    }

    public CharacterGenerator(String pattern) {
        this(pattern, LocaleUtil.getFallbackLocale());
    }

    public CharacterGenerator(String pattern, Locale locale) {
        this.pattern = pattern;
        this.locale = locale;
        this.values = new HashSet<Character>();
        this.dirty = true;
    }

    public CharacterGenerator(Collection<Character> values) {
        this.pattern = null;
        this.locale = LocaleUtil.getFallbackLocale();
        this.values = new HashSet<Character>(values);
        this.dirty = true;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.dirty = true;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.dirty = true;
    }

    public Set<Character> getValues() {
        return this.values;
    }

    public void setValues(Set<Character> set) {
        this.source.setValues((Collection<Character>)set);
        this.dirty = true;
    }

    @Override
    public Class<Character> getGeneratedType() {
        return Character.class;
    }

    @Override
    public void validate() {
        if (this.dirty) {
            try {
                if (this.pattern != null) {
                    this.values = new RegexParser(this.locale).parseCharSet(new RegexTokenizer(this.pattern));
                }
                this.source = new WeightedSampleGenerator<Character>(Character.class, (Collection<Character>)this.values);
                this.source.validate();
                this.dirty = false;
            }
            catch (ParseException e) {
                throw new IllegalGeneratorStateException(e);
            }
        }
    }

    @Override
    public Character generate() {
        if (this.dirty) {
            this.validate();
        }
        return this.source.generate();
    }

    @Override
    public void reset() {
        if (this.dirty) {
            this.validate();
        }
        this.source.reset();
    }

    @Override
    public void close() {
        if (this.dirty) {
            this.validate();
        }
        this.source.close();
    }

    @Override
    public boolean available() {
        if (this.dirty) {
            this.validate();
        }
        return this.source.available();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.values;
    }
}

