/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.Generator;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.primitive.IncrementGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiLoGenerator
implements Generator<Long> {
    private static final Log logger = LogFactory.getLog(HiLoGenerator.class);
    protected static final int DEFAULT_MAX_LO = 100;
    protected int maxLo;
    private int lo;
    private long hi;
    protected Generator<Long> hiGenerator;
    protected boolean dirty;

    public HiLoGenerator() {
        this(new IncrementGenerator(), 100);
    }

    public HiLoGenerator(Generator<Long> hiGenerator) {
        this(hiGenerator, 100);
    }

    public HiLoGenerator(Generator<Long> hiGenerator, int maxLo) {
        this.hiGenerator = hiGenerator;
        this.setMaxLo(maxLo);
        this.lo = -1;
        this.hi = -1L;
        this.dirty = true;
    }

    public void setHiGenerator(Generator<Long> hiGenerator) {
        this.hiGenerator = hiGenerator;
    }

    public int getMaxLo() {
        return this.maxLo;
    }

    public void setMaxLo(int maxLo) {
        if (maxLo <= 0) {
            throw new IllegalArgumentException("maxLo must be greater than 0, was: " + maxLo);
        }
        this.maxLo = maxLo;
        this.dirty = true;
    }

    @Override
    public Class<Long> getGeneratedType() {
        return Long.class;
    }

    @Override
    public void validate() {
        if (this.dirty) {
            if (this.hiGenerator == null) {
                throw new InvalidGeneratorSetupException("hiGenerator", "is null");
            }
            this.hiGenerator.validate();
            this.dirty = false;
        }
    }

    @Override
    public boolean available() {
        if (this.dirty) {
            this.validate();
        }
        return this.hiGenerator.available();
    }

    @Override
    public Long generate() {
        if (this.dirty) {
            this.validate();
        }
        if (this.hi == -1L || this.lo >= this.maxLo) {
            this.hi = this.hiGenerator.generate();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("fetched new hi value: " + this.hi));
            }
            this.lo = 0;
        } else {
            ++this.lo;
        }
        return this.hi * (long)(this.maxLo + 1) + (long)this.lo;
    }

    @Override
    public void reset() {
        if (this.dirty) {
            this.validate();
        }
        this.hiGenerator.reset();
        this.hi = -1L;
        this.dirty = true;
    }

    @Override
    public void close() {
        if (this.dirty) {
            this.validate();
        }
        this.hiGenerator.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.maxLo + ',' + this.hiGenerator + ']';
    }
}

