/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive;

import java.util.Set;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.primitive.number.distribution.BitReverseNaturalNumberGenerator;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.benerator.util.SimpleRandom;
import org.databene.commons.ArrayFormat;
import org.databene.commons.CollectionUtil;
import org.databene.commons.CustomCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueFixedLengthStringGenerator
extends LightweightGenerator<String> {
    public static final Set<Character> DEFAULT_CHAR_SET = CollectionUtil.toSet((Object[])new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')});
    public static final Set<Character> ORDERED_CHAR_SET = CollectionUtil.toSortedSet((Object[])new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')});
    private static final int DEFAULT_LENGTH = 4;
    private int radix;
    private int length;
    private CustomCounter counter;
    private char[] digitSymbols;
    private int[] displayColumn;
    private int[] seed;
    private int cycleCounter;

    public UniqueFixedLengthStringGenerator() {
        this(4, DEFAULT_CHAR_SET);
    }

    public UniqueFixedLengthStringGenerator(int length, Set<Character> charSet) {
        this(length, CollectionUtil.toArray(charSet));
    }

    public UniqueFixedLengthStringGenerator(int length, char ... chars) {
        super(String.class);
        this.radix = chars.length;
        this.digitSymbols = chars;
        this.length = length;
        this.displayColumn = new int[length];
        this.seed = new int[length];
        BitReverseNaturalNumberGenerator gen = new BitReverseNaturalNumberGenerator(length - 1);
        for (int i = 0; i < length; ++i) {
            this.displayColumn[i] = ((Long)gen.generate()).intValue();
            this.seed[i] = SimpleRandom.randomInt(0, length - 1);
        }
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.counter = new CustomCounter(this.radix, this.length);
        this.cycleCounter = 0;
    }

    @Override
    public boolean available() {
        return this.counter != null;
    }

    @Override
    public String generate() {
        if (this.counter == null) {
            throw new IllegalGeneratorStateException("Generator is not available any more. Check with available() before calling!");
        }
        int[] digits = this.counter.getDigits();
        char[] tmp = new char[this.length];
        for (int i = 0; i < digits.length; ++i) {
            tmp[this.displayColumn[i]] = this.digitSymbols[(this.seed[i] + digits[i] + this.cycleCounter) % this.radix];
        }
        String result = new String(tmp);
        if (this.cycleCounter < this.radix - 1 && this.length > 0) {
            ++this.cycleCounter;
        } else {
            this.counter.increment();
            this.cycleCounter = 0;
            if (this.counter.hasOverrun() || this.radix == 1 || digits[this.length - 1] > 0) {
                this.counter = null;
            }
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[length=" + this.length + ", charset=" + ArrayFormat.formatChars((String)",", (char[])this.digitSymbols) + ']';
    }
}

