/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive;

import java.util.Set;
import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.primitive.UniqueFixedLengthStringGenerator;
import org.databene.benerator.util.SimpleRandom;
import org.databene.commons.ArrayFormat;
import org.databene.commons.CharSet;
import org.databene.commons.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueStringGenerator
implements Generator<String> {
    private int minLength;
    private int maxLength;
    private char[] charSet;
    private Generator<String>[] subGens;
    private boolean dirty;

    public UniqueStringGenerator() {
        this(4, 8, new CharSet('A', 'Z').getSet());
    }

    public UniqueStringGenerator(int minLength, int maxLength, Set<Character> charSet) {
        this(minLength, maxLength, CollectionUtil.toArray(charSet));
    }

    public UniqueStringGenerator(int minLength, int maxLength, char ... charSet) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.charSet = charSet;
        this.subGens = new Generator[0];
        this.dirty = true;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
        this.dirty = true;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        this.dirty = true;
    }

    @Override
    public Class<String> getGeneratedType() {
        return String.class;
    }

    @Override
    public void validate() {
        if (this.dirty) {
            this.subGens = new Generator[this.maxLength - this.minLength + 1];
            for (int i = this.minLength; i <= this.maxLength; ++i) {
                this.subGens[i - this.minLength] = new UniqueFixedLengthStringGenerator(i, this.charSet);
            }
            this.dirty = false;
        }
    }

    @Override
    public boolean available() {
        if (this.dirty) {
            this.validate();
        }
        if (this.subGens == null) {
            return false;
        }
        for (int i = this.maxLength - this.minLength; i >= 0; --i) {
            if (!this.subGens[i].available()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String generate() {
        int generatorIndex;
        if (!this.available()) {
            throw new IllegalGeneratorStateException("Generator is no longer available");
        }
        while (!this.subGens[generatorIndex = SimpleRandom.randomInt(0, this.maxLength - this.minLength)].available()) {
        }
        return this.subGens[generatorIndex].generate();
    }

    @Override
    public void reset() {
        if (this.subGens != null) {
            for (Generator<String> generator : this.subGens) {
                generator.reset();
            }
        }
        this.dirty = true;
    }

    @Override
    public void close() {
        if (this.subGens != null) {
            for (Generator<String> generator : this.subGens) {
                generator.close();
            }
            this.subGens = null;
        }
        this.dirty = true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.minLength + "<=length<=" + this.maxLength + ", " + "charSet=[" + ArrayFormat.formatChars((String)", ", (char[])this.charSet) + "]]";
    }
}

