/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.datetime;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.databene.benerator.Generator;
import org.databene.benerator.primitive.number.adapter.LongGenerator;
import org.databene.commons.Period;
import org.databene.commons.converter.DateString2DurationConverter;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateGenerator
implements Generator<Date> {
    private DateString2DurationConverter dateConverter = new DateString2DurationConverter();
    private LongGenerator source;

    public DateGenerator() {
        this(DateGenerator.defaultStartDate(), DateGenerator.currentDay(), Period.DAY.getMillis());
    }

    public DateGenerator(Date min, Date max, long precision) {
        this(min, max, precision, Sequence.RANDOM);
    }

    public DateGenerator(Date min, Date max, long precision, Distribution distribution) {
        this.source = new LongGenerator(min != null ? min.getTime() : Long.MIN_VALUE, max != null ? max.getTime() : Long.MAX_VALUE, precision, distribution);
    }

    public DateGenerator(Date min, Date max, long precision, Distribution distribution, Date variation1, Date variation2) {
        this.source = new LongGenerator(min != null ? min.getTime() : Long.MIN_VALUE, max != null ? max.getTime() : Long.MAX_VALUE, precision, distribution, variation1 != null ? variation1.getTime() + (long)TimeZone.getDefault().getRawOffset() : 1000L, variation2 != null ? variation2.getTime() + (long)TimeZone.getDefault().getRawOffset() : 1000L);
    }

    public Date getMin() {
        return new Date((Long)this.source.getMin());
    }

    public void setMin(Date min) {
        this.source.setMin(min.getTime());
    }

    public Date getMax() {
        return new Date((Long)this.source.getMax());
    }

    public void setMax(Date max) {
        this.source.setMax(max.getTime());
    }

    public void setPrecision(String precision) {
        this.source.setPrecision((Number)this.dateConverter.convert((Object)precision));
    }

    public Distribution getDistribution() {
        return this.source.getDistribution();
    }

    public void setDistribution(Distribution distribution) {
        this.source.setDistribution(distribution);
    }

    public Long getVariation1() {
        return (Long)this.source.getVariation1();
    }

    public void setVariation1(Long varation1) {
        this.source.setVariation1(varation1);
    }

    public Long getVariation2() {
        return (Long)this.source.getVariation2();
    }

    public void setVariation2(Long variation2) {
        this.source.setVariation2(variation2);
    }

    @Override
    public Class<Date> getGeneratedType() {
        return Date.class;
    }

    @Override
    public void validate() {
        this.source.validate();
    }

    @Override
    public Date generate() {
        return new Date((Long)this.source.generate());
    }

    @Override
    public void reset() {
        this.source.reset();
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    public boolean available() {
        return this.source.available();
    }

    private static Date defaultStartDate() {
        return new Date(DateGenerator.currentDay().getTime() - 29200L * Period.DAY.getMillis());
    }

    private static Date currentDay() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.getMin() + '-' + this.getMax() + ']';
    }
}

