/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.datetime;

import java.sql.Time;
import java.util.Date;
import org.databene.benerator.primitive.number.adapter.LongGenerator;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.commons.TimeUtil;
import org.databene.commons.converter.DateString2DurationConverter;
import org.databene.model.function.Sequence;
import org.databene.model.function.String2DistributionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeGenerator
extends LightweightGenerator<Date> {
    private DateString2DurationConverter dateConverter = new DateString2DurationConverter();
    private LongGenerator dateGenerator = new LongGenerator();
    private LongGenerator timeGenerator = new LongGenerator();

    public DateTimeGenerator() {
        this(TimeUtil.add((Date)TimeUtil.today().getTime(), (int)1, (int)-1), TimeUtil.today().getTime(), TimeUtil.time((int)9, (int)0), TimeUtil.time((int)17, (int)0));
    }

    public DateTimeGenerator(Date minDate, Date maxDate, Time minTime, Time maxTine) {
        super(Date.class);
        this.setMinDate(minDate);
        this.setMaxDate(maxDate);
        this.setMinTime(minTime);
        this.setMaxTime(maxTine);
    }

    public void setMinDate(Date minDate) {
        this.dateGenerator.setMin(minDate.getTime());
    }

    public void setMaxDate(Date maxDate) {
        this.dateGenerator.setMax(maxDate.getTime());
    }

    public void setDatePrecision(String datePrecision) {
        this.dateGenerator.setPrecision((Number)this.dateConverter.convert((Object)datePrecision));
    }

    public void setDateDistribution(String distribution) {
        this.dateGenerator.setDistribution(Sequence.getInstance(distribution, true));
    }

    public void setMinTime(Time minTime) {
        this.timeGenerator.setMin(minTime.getTime());
    }

    public void setMaxTime(Time maxTime) {
        this.timeGenerator.setMax(maxTime.getTime());
    }

    public void setTimePrecision(Time timePrecision) {
        this.timeGenerator.setPrecision(timePrecision.getTime());
    }

    public void setTimeDistribution(String distribution) {
        this.timeGenerator.setDistribution(String2DistributionConverter.parse(distribution, null, null));
    }

    @Override
    public Date generate() {
        return new Date((Long)this.dateGenerator.generate() + (Long)this.timeGenerator.generate());
    }
}

