/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number;

import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.primitive.number.NumberGenerator;
import org.databene.benerator.util.LightweightGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDoubleGenerator
extends LightweightGenerator<Double>
implements NumberGenerator<Double> {
    protected double min;
    protected double max;
    protected double precision;
    protected double variation1;
    protected double variation2;
    protected boolean dirty;

    protected AbstractDoubleGenerator() {
        this(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    protected AbstractDoubleGenerator(double min, double max) {
        this(min, max, 1.0);
    }

    protected AbstractDoubleGenerator(double min, double max, double precision) {
        this(min, max, precision, 1.0, 1.0);
    }

    protected AbstractDoubleGenerator(double min, double max, double precision, double variation1, double variation2) {
        super(Double.class);
        if (min > max) {
            throw new IllegalArgumentException("min. value (" + min + ") is greater than max. value (" + max + ')');
        }
        this.min = min;
        this.max = max;
        if (precision < 0.0) {
            throw new IllegalArgumentException("Unsupported precision: " + precision);
        }
        this.precision = precision;
        this.variation1 = variation1;
        this.variation2 = variation2;
        this.dirty = true;
    }

    @Override
    public Double getMin() {
        return this.min;
    }

    @Override
    public void setMin(Double min) {
        this.min = min;
        this.dirty = true;
    }

    @Override
    public Double getMax() {
        return this.max;
    }

    @Override
    public void setMax(Double max) {
        this.max = max;
        this.dirty = true;
    }

    @Override
    public Double getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(Double precision) {
        this.precision = precision;
        this.dirty = true;
    }

    @Override
    public Double getVariation1() {
        return this.variation1;
    }

    @Override
    public void setVariation1(Double variation1) {
        this.variation1 = variation1;
        this.dirty = true;
    }

    @Override
    public Double getVariation2() {
        return this.variation2;
    }

    @Override
    public void setVariation2(Double variation2) {
        this.variation2 = variation2;
        this.dirty = true;
    }

    @Override
    public Class<Double> getGeneratedType() {
        return Double.class;
    }

    @Override
    public void validate() {
        if (this.dirty) {
            if (this.min > this.max) {
                throw new InvalidGeneratorSetupException("min", "greater than max (" + this.min + ")");
            }
            super.validate();
            this.dirty = false;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[min=" + this.min + ", max=" + this.max + ", precision=" + this.precision + ", " + "variation1=" + this.variation1 + ", variation2=" + this.variation2 + ']';
    }
}

