/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number;

import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.primitive.number.NumberGenerator;
import org.databene.benerator.util.LightweightGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLongGenerator
extends LightweightGenerator<Long>
implements NumberGenerator<Long> {
    protected long min;
    protected long max;
    protected long precision;
    protected long variation1;
    protected long variation2;
    protected boolean dirty;

    protected AbstractLongGenerator() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    protected AbstractLongGenerator(long min, long max) {
        this(min, max, 1L);
    }

    protected AbstractLongGenerator(long min, long max, long precision) {
        this(min, max, precision, 1L, 1L);
    }

    protected AbstractLongGenerator(long min, long max, long precision, long variation1, long variation2) {
        super(Long.class);
        this.setMin(min);
        this.setMax(max);
        this.setPrecision(precision);
        this.setVariation1(variation1);
        this.setVariation2(variation2);
        this.dirty = true;
    }

    @Override
    public Long getMin() {
        return this.min;
    }

    @Override
    public void setMin(Long min) {
        this.min = min;
        this.dirty = true;
    }

    @Override
    public Long getMax() {
        return this.max;
    }

    @Override
    public void setMax(Long max) {
        this.max = max;
        this.dirty = true;
    }

    @Override
    public Long getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(Long precision) {
        this.precision = precision;
        this.dirty = true;
    }

    @Override
    public Long getVariation1() {
        return this.variation1;
    }

    @Override
    public void setVariation1(Long variation1) {
        this.variation1 = variation1;
        this.dirty = true;
    }

    @Override
    public Long getVariation2() {
        return this.variation2;
    }

    @Override
    public void setVariation2(Long variation2) {
        this.variation2 = variation2;
        this.dirty = true;
    }

    @Override
    public Class<Long> getGeneratedType() {
        return Long.class;
    }

    @Override
    public void validate() {
        if (this.min > this.max) {
            throw new InvalidGeneratorSetupException("min", " min (" + this.min + ") greater than max (" + this.max + ')');
        }
        super.validate();
        this.dirty = false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[min=" + this.min + ", max=" + this.max + ", precision=" + this.precision + ", " + "variation1=" + this.variation1 + ", variation2=" + this.variation2 + ']';
    }
}

