/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number;

import org.databene.benerator.primitive.number.AbstractDoubleGenerator;
import org.databene.benerator.primitive.number.AbstractLongGenerator;

public class DoubleFromLongGenerator
extends AbstractDoubleGenerator {
    private AbstractLongGenerator indexGenerator;

    public DoubleFromLongGenerator(AbstractLongGenerator longGenerator) {
        this.indexGenerator = longGenerator;
    }

    public void validate() {
        if (this.dirty) {
            super.validate();
            this.indexGenerator.setMin(0L);
            long maxIndex = (long)((this.max - this.min) / this.precision);
            this.indexGenerator.setMax(maxIndex);
            this.indexGenerator.validate();
        }
    }

    public boolean available() {
        return this.indexGenerator.available();
    }

    public Double generate() {
        if (this.dirty) {
            this.validate();
        }
        return this.min + (double)((Long)this.indexGenerator.generate()).longValue() * this.precision;
    }

    public void reset() {
        super.reset();
        this.indexGenerator.reset();
    }

    public void close() {
        super.close();
        this.indexGenerator.close();
    }
}

