/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.adapter;

import org.databene.benerator.primitive.number.NumberGenerator;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.commons.converter.NumberToNumberConverter;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;
import org.databene.model.function.WeightFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumberGenerator<P extends Number, S extends Number>
extends LightweightGenerator<P>
implements NumberGenerator<P> {
    protected P min;
    protected P max;
    protected P precision;
    protected P variation1;
    protected P variation2;
    protected Distribution distribution;
    protected NumberGenerator<S> source;
    protected boolean dirty;

    public AbstractNumberGenerator(Class<P> type, P min, P max, P precision) {
        this(type, min, max, precision, Sequence.RANDOM);
    }

    public AbstractNumberGenerator(Class<P> type, P min, P max, P precision, Distribution distribution) {
        this(type, min, max, precision, distribution, AbstractNumberGenerator.one(type), AbstractNumberGenerator.one(type));
    }

    private static <T extends Number> T one(Class<T> type) {
        return (T)NumberToNumberConverter.convert((Number)1, type);
    }

    public AbstractNumberGenerator(Class<P> type, P min, P max, P precision, Distribution distribution, P variation1, P variation2) {
        super(type);
        this.distribution = distribution;
        this.setMin(min);
        this.setMax(max);
        this.setPrecision(precision);
        this.setVariation1(variation1);
        this.setVariation2(variation2);
        this.dirty = true;
    }

    @Override
    public P getMin() {
        return (P)NumberToNumberConverter.convert(this.min, (Class)this.generatedType);
    }

    @Override
    public void setMin(P min) {
        this.min = min;
        this.dirty = true;
    }

    @Override
    public P getMax() {
        return (P)NumberToNumberConverter.convert(this.max, (Class)this.generatedType);
    }

    @Override
    public void setMax(P max) {
        this.max = max;
        this.dirty = true;
    }

    @Override
    public P getPrecision() {
        return (P)NumberToNumberConverter.convert(this.precision, (Class)this.generatedType);
    }

    @Override
    public void setPrecision(P precision) {
        this.precision = precision;
        this.dirty = true;
    }

    @Override
    public P getVariation1() {
        return this.variation1;
    }

    @Override
    public void setVariation1(P variation1) {
        this.variation1 = variation1;
        this.dirty = true;
    }

    @Override
    public P getVariation2() {
        return this.variation2;
    }

    @Override
    public void setVariation2(P variation2) {
        this.variation2 = variation2;
        this.dirty = true;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(Distribution distribution) {
        this.distribution = distribution;
    }

    @Override
    public void validate() {
        if (this.dirty) {
            if (this.distribution == null) {
                throw new IllegalArgumentException("distribution is null");
            }
            if (this.distribution instanceof Sequence) {
                this.source = this.createSource((Sequence)this.distribution);
            } else if (this.distribution instanceof WeightFunction) {
                this.source = this.createSource((WeightFunction)this.distribution);
            }
            this.source.validate();
            this.dirty = false;
        }
    }

    @Override
    public boolean available() {
        if (this.dirty) {
            this.validate();
        }
        return this.source.available();
    }

    @Override
    public void reset() {
        if (this.dirty) {
            this.validate();
        }
        super.reset();
        this.source.reset();
    }

    @Override
    public void close() {
        if (this.source != null) {
            this.source.close();
        }
        super.close();
    }

    protected abstract NumberGenerator<S> createSource(WeightFunction var1);

    protected abstract NumberGenerator<S> createSource(Sequence var1);

    public String toString() {
        return this.getClass().getSimpleName() + "[source=" + this.source + ']';
    }
}

