/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.adapter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.databene.benerator.primitive.number.adapter.IntegralNumberGenerator;
import org.databene.commons.MathUtil;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalGenerator
extends IntegralNumberGenerator<BigDecimal> {
    public static final BigDecimal DEFAULT_PRECISION = new BigDecimal("0.01");
    private Integer fractionDigits;

    public BigDecimalGenerator() {
        this(new BigDecimal(Long.MIN_VALUE), new BigDecimal(Long.MAX_VALUE));
    }

    public BigDecimalGenerator(BigDecimal min, BigDecimal max) {
        this(min, max, DEFAULT_PRECISION);
    }

    public BigDecimalGenerator(BigDecimal min, BigDecimal max, BigDecimal precision) {
        this(min, max, precision, Sequence.RANDOM);
    }

    public BigDecimalGenerator(BigDecimal min, BigDecimal max, BigDecimal precision, Distribution distribution) {
        this(min, max, precision, distribution, BigDecimal.valueOf(1L), BigDecimal.valueOf(1L));
    }

    public BigDecimalGenerator(BigDecimal min, BigDecimal max, BigDecimal precision, Distribution distribution, BigDecimal variation1, BigDecimal variation2) {
        super(BigDecimal.class, min, max, precision, distribution, variation1, variation2);
    }

    @Override
    public void setPrecision(BigDecimal precision) {
        super.setPrecision(precision);
        this.fractionDigits = Math.max(MathUtil.fractionDigits((double)((BigDecimal)this.min).doubleValue()), MathUtil.fractionDigits((double)precision.doubleValue()));
        this.dirty = true;
    }

    public Integer getFractionDigits() {
        return this.fractionDigits;
    }

    @Override
    public void validate() {
        if (this.dirty) {
            super.validate();
            this.dirty = true;
            this.source.setMin(0L);
            this.source.setMax((long)((((BigDecimal)this.max).doubleValue() - ((BigDecimal)this.min).doubleValue()) / ((BigDecimal)this.precision).doubleValue()));
            this.source.setPrecision(1L);
            this.source.validate();
            this.dirty = false;
        }
    }

    @Override
    public BigDecimal generate() {
        if (this.dirty) {
            this.validate();
        }
        BigDecimal tmp = ((BigDecimal)super.generate()).multiply((BigDecimal)this.precision).add((BigDecimal)this.min);
        return tmp.setScale((int)this.fractionDigits, RoundingMode.HALF_UP);
    }
}

