/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.adapter;

import org.databene.benerator.primitive.number.AbstractDoubleGenerator;
import org.databene.benerator.primitive.number.NumberGenerator;
import org.databene.benerator.primitive.number.adapter.AbstractNumberGenerator;
import org.databene.benerator.primitive.number.adapter.SequenceFactory;
import org.databene.benerator.primitive.number.distribution.WeightedDoubleGenerator;
import org.databene.commons.converter.NumberToNumberConverter;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;
import org.databene.model.function.WeightFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatingPointNumberGenerator<E extends Number>
extends AbstractNumberGenerator<E, Double> {
    public FloatingPointNumberGenerator(Class<E> type, E min, E max, E precision) {
        super(type, min, max, precision);
    }

    public FloatingPointNumberGenerator(Class<E> type, E min, E max, E precision, Distribution distribution) {
        super(type, min, max, precision, distribution);
    }

    public FloatingPointNumberGenerator(Class<E> type, E min, E max, E precision, Distribution distribution, E variation1, E variation2) {
        super(type, min, max, precision, distribution, variation1, variation2);
    }

    @Override
    public E generate() {
        if (this.dirty) {
            this.validate();
        }
        Double x = (Double)this.source.generate();
        return (E)NumberToNumberConverter.convert((Number)x, (Class)this.generatedType);
    }

    @Override
    protected NumberGenerator<Double> createSource(WeightFunction function) {
        return new WeightedDoubleGenerator(this.min.doubleValue(), this.max.doubleValue(), this.precision.doubleValue(), function);
    }

    @Override
    protected NumberGenerator<Double> createSource(Sequence sequence) {
        AbstractDoubleGenerator doubleGenerator = SequenceFactory.createDoubleGenerator(sequence);
        doubleGenerator.setMin(this.min.doubleValue());
        doubleGenerator.setMax(this.max.doubleValue());
        doubleGenerator.setPrecision(this.precision.doubleValue());
        doubleGenerator.setVariation1(this.variation1.doubleValue());
        doubleGenerator.setVariation2(this.variation2.doubleValue());
        return doubleGenerator;
    }
}

