/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.adapter;

import org.databene.benerator.primitive.number.AbstractLongGenerator;
import org.databene.benerator.primitive.number.NumberGenerator;
import org.databene.benerator.primitive.number.adapter.AbstractNumberGenerator;
import org.databene.benerator.primitive.number.adapter.SequenceFactory;
import org.databene.benerator.primitive.number.distribution.WeightedLongGenerator;
import org.databene.commons.ConversionException;
import org.databene.commons.converter.NumberConverter;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;
import org.databene.model.function.WeightFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegralNumberGenerator<E extends Number>
extends AbstractNumberGenerator<E, Long> {
    public IntegralNumberGenerator(Class<E> type, E min, E max, E precision) {
        super(type, min, max, precision);
    }

    public IntegralNumberGenerator(Class<E> type, E min, E max, E precision, Distribution distribution) {
        super(type, min, max, precision, distribution);
    }

    public IntegralNumberGenerator(Class<E> type, E min, E max, E precision, Distribution distribution, E variation1, E variation2) {
        super(type, min, max, precision, distribution, variation1, variation2);
    }

    @Override
    public E generate() {
        if (this.dirty) {
            this.validate();
        }
        Long n = (Long)this.source.generate();
        try {
            return (E)((Number)NumberConverter.convert((Number)n, (Class)this.generatedType));
        }
        catch (ConversionException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    @Override
    protected NumberGenerator<Long> createSource(WeightFunction function) {
        return new WeightedLongGenerator(this.min.longValue(), this.max.longValue(), this.precision.longValue(), function);
    }

    @Override
    protected NumberGenerator<Long> createSource(Sequence sequence) {
        AbstractLongGenerator longGenerator = SequenceFactory.createLongGenerator(sequence);
        longGenerator.setMin(this.min.longValue());
        longGenerator.setMax(this.max.longValue());
        longGenerator.setPrecision(this.precision.longValue());
        longGenerator.setVariation1(this.variation1.longValue());
        longGenerator.setVariation2(this.variation2.longValue());
        return longGenerator;
    }
}

