/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.adapter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.databene.benerator.primitive.number.AbstractDoubleGenerator;
import org.databene.benerator.primitive.number.AbstractLongGenerator;
import org.databene.benerator.primitive.number.DoubleFromLongGenerator;
import org.databene.benerator.primitive.number.LongFromDoubleGenerator;
import org.databene.benerator.primitive.number.NumberGenerator;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.IOUtil;
import org.databene.commons.StringUtil;
import org.databene.model.function.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceFactory {
    private static final String CONFIG_FILE_NAME = "org/databene/benerator/sequence.properties";
    private static final Map<String, SequenceDef> defs = new HashMap<String, SequenceDef>();

    public static Sequence defineSequence(String name, Class<AbstractDoubleGenerator> dgClass, Class<AbstractLongGenerator> ngClass) {
        new SequenceDef(name, dgClass, ngClass);
        return new Sequence(name);
    }

    public static Sequence defineSequence(String name, Class<? extends NumberGenerator> dgClass) {
        new SequenceDef(name, dgClass);
        return new Sequence(name);
    }

    static AbstractLongGenerator createLongGenerator(Sequence sequence) {
        SequenceDef def = defs.get(sequence.getName());
        if (def == null) {
            throw new ConfigurationError("Sequence not defined: " + sequence.getName());
        }
        if (LongFromDoubleGenerator.class.equals(def.longGeneratorClass)) {
            return new LongFromDoubleGenerator(SequenceFactory.createDoubleGenerator(sequence));
        }
        return (AbstractLongGenerator)BeanUtil.newInstance(def.longGeneratorClass, (Object[])new Object[0]);
    }

    static AbstractDoubleGenerator createDoubleGenerator(Sequence sequence) {
        SequenceDef def = defs.get(sequence.getName());
        if (DoubleFromLongGenerator.class.equals(def.doubleGeneratorClass)) {
            return new DoubleFromLongGenerator(SequenceFactory.createLongGenerator(sequence));
        }
        return (AbstractDoubleGenerator)BeanUtil.newInstance(def.doubleGeneratorClass, (Object[])new Object[0]);
    }

    static {
        try {
            Map properties = IOUtil.readProperties((String)CONFIG_FILE_NAME);
            for (Map.Entry entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                String setup = (String)entry.getValue();
                String[] generatorClasses = StringUtil.tokenize((String)setup, (char)',');
                Class dgClass = BeanUtil.forName((String)generatorClasses[0]);
                if (generatorClasses.length == 1) {
                    SequenceFactory.defineSequence(name, dgClass);
                    continue;
                }
                Class ngClass = BeanUtil.forName((String)generatorClasses[1]);
                SequenceFactory.defineSequence(name, dgClass, ngClass);
            }
        }
        catch (IOException e) {
            throw new ConfigurationError("Configuration file cannot be read", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SequenceDef {
        String name;
        Class<? extends AbstractLongGenerator> longGeneratorClass;
        Class<? extends AbstractDoubleGenerator> doubleGeneratorClass;

        SequenceDef(String name, Class<? extends NumberGenerator> numberGeneratorClass) {
            this(name, AbstractDoubleGenerator.class.isAssignableFrom(numberGeneratorClass) ? numberGeneratorClass : DoubleFromLongGenerator.class, AbstractLongGenerator.class.isAssignableFrom(numberGeneratorClass) ? numberGeneratorClass : LongFromDoubleGenerator.class);
        }

        SequenceDef(String name, Class<? extends AbstractDoubleGenerator> doubleGeneratorClass, Class<? extends AbstractLongGenerator> longGeneratorClass) {
            this.name = name;
            this.longGeneratorClass = longGeneratorClass;
            this.doubleGeneratorClass = doubleGeneratorClass;
            if (defs.get(name) != null) {
                throw new ConfigurationError("Sequence defined twice: " + name);
            }
            defs.put(name, this);
        }
    }
}

