/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.primitive.number.AbstractLongGenerator;
import org.databene.benerator.primitive.number.distribution.BitReverseNaturalNumberGenerator;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

public class BitReverseLongGenerator
extends AbstractLongGenerator {
    private BitReverseNaturalNumberGenerator indexGenerator;

    public BitReverseLongGenerator() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public BitReverseLongGenerator(long min, long max) {
        this(min, max, 1L);
    }

    public BitReverseLongGenerator(long min, long max, long precision) {
        super(min, max, precision);
    }

    public Distribution getDistribution() {
        return Sequence.SHUFFLE;
    }

    public void validate() {
        if (this.dirty) {
            super.validate();
            this.indexGenerator = new BitReverseNaturalNumberGenerator((this.max - this.min + this.precision - 1L) / this.precision);
            this.dirty = false;
        }
    }

    public boolean available() {
        if (this.dirty) {
            this.validate();
        }
        return this.indexGenerator.available();
    }

    public Long generate() throws IllegalGeneratorStateException {
        if (this.dirty) {
            this.validate();
        }
        return this.min + this.indexGenerator.generate() * this.precision;
    }

    public void reset() {
        super.reset();
        this.indexGenerator.reset();
    }

    public void close() {
        super.close();
        this.indexGenerator.close();
    }
}

