/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.commons.NumberUtil;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitReverseNaturalNumberGenerator
extends LightweightGenerator<Long> {
    private long max;
    private long cursor;
    private Long next;
    private int bitsUsed;
    private long maxCursor;
    private boolean dirty;

    public BitReverseNaturalNumberGenerator() {
        this(Long.MAX_VALUE);
    }

    public BitReverseNaturalNumberGenerator(long max) {
        super(Long.class);
        this.max = max;
        this.dirty = true;
    }

    @Override
    public Class<Long> getGeneratedType() {
        return Long.class;
    }

    public Distribution getDistribution() {
        return Sequence.BIT_REVERSE;
    }

    public void setMax(Long max) {
        if (max < 0L) {
            throw new IllegalArgumentException("No negative min supported, was: " + max);
        }
        this.max = max;
        this.dirty = true;
    }

    @Override
    public void validate() {
        if (this.dirty) {
            super.validate();
            this.cursor = 0L;
            this.bitsUsed = NumberUtil.bitsUsed((long)this.max);
            this.next = 0L;
            this.maxCursor = 1 << this.bitsUsed;
            this.dirty = false;
        }
    }

    @Override
    public boolean available() {
        if (this.dirty) {
            this.validate();
        }
        return this.next != null;
    }

    @Override
    public Long generate() throws IllegalGeneratorStateException {
        if (this.dirty) {
            this.validate();
        }
        if (this.next == null) {
            throw new IllegalGeneratorStateException("No numbers available any more");
        }
        long result = this.next;
        do {
            ++this.cursor;
            this.next = this.cursorReversed();
        } while (this.next > this.max && this.cursor < this.maxCursor);
        if (this.cursor >= this.maxCursor) {
            this.next = null;
        }
        return result;
    }

    @Override
    public void reset() {
        super.reset();
        this.dirty = true;
        this.validate();
    }

    @Override
    public void close() {
        super.close();
        this.next = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.renderState() + ']';
    }

    private long cursorReversed() {
        long result = 0L;
        for (int i = 0; i <= this.bitsUsed; ++i) {
            result |= (this.cursor >> i & 1L) << this.bitsUsed - i - 1;
        }
        return result;
    }

    private String renderState() {
        return "max=" + this.max + ", cursor=" + this.cursor;
    }
}

