/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import org.databene.benerator.primitive.number.AbstractDoubleGenerator;
import org.databene.benerator.primitive.number.distribution.RandomDoubleGenerator;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

public class CumulatedDoubleGenerator
extends AbstractDoubleGenerator {
    public CumulatedDoubleGenerator() {
        this(-9.223372036854776E18, 9.223372036854776E18);
    }

    public CumulatedDoubleGenerator(double min, double max) {
        this(min, max, 1.0);
    }

    public CumulatedDoubleGenerator(double min, double max, double precision) {
        super(min, max, precision);
    }

    public Distribution getDistribution() {
        return Sequence.CUMULATED;
    }

    public float getAverage() {
        return (float)(this.max + this.min) / 2.0f;
    }

    public Double generate() {
        RandomDoubleGenerator baseGen = new RandomDoubleGenerator(this.min, this.max);
        double exactValue = (baseGen.generate() + baseGen.generate() + baseGen.generate() + baseGen.generate() + baseGen.generate()) / 5.0;
        return this.min + (double)((int)Math.round((exactValue - this.min) / this.precision)) * this.precision;
    }
}

