/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import org.databene.benerator.primitive.number.AbstractLongGenerator;
import org.databene.benerator.primitive.number.distribution.RandomLongGenerator;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

public class CumulatedLongGenerator
extends AbstractLongGenerator {
    public CumulatedLongGenerator() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public CumulatedLongGenerator(long min, long max) {
        this(min, max, 1L);
    }

    public CumulatedLongGenerator(long min, long max, long precision) {
        super(min, max, precision);
    }

    public Distribution getDistribution() {
        return Sequence.CUMULATED;
    }

    public float average() {
        return (float)(this.max + this.min) / 2.0f;
    }

    public Long generate() {
        RandomLongGenerator baseGen = new RandomLongGenerator(this.min, this.max);
        long exactValue = (baseGen.generate() + baseGen.generate() + baseGen.generate() + baseGen.generate() + baseGen.generate() + 2L) / 5L;
        return this.min + (exactValue - this.min) / this.precision * this.precision;
    }
}

