/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import org.databene.model.function.WeightFunction;

public class GaussianFunction
implements WeightFunction {
    private double average;
    private double deviation;
    private double scale;

    public GaussianFunction(double average, double deviation) {
        this.average = average;
        this.deviation = deviation;
        this.scale = 1.0 / deviation / Math.sqrt(Math.PI * 2);
    }

    public double getAverage() {
        return this.average;
    }

    public double getDeviation() {
        return this.deviation;
    }

    public double value(double param) {
        double x = (param - this.average) / this.deviation;
        return this.scale * Math.exp(-0.5 * x * x);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[1. / (" + this.deviation + "*sqrt(2*PI)) * e^(-" + (this.average != 0.0 ? "(x - " + this.average + ")" : "x") + "^2/" + 2.0 * this.deviation * this.deviation + ")]";
    }
}

