/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import org.databene.benerator.primitive.number.AbstractDoubleGenerator;
import org.databene.benerator.util.SimpleRandom;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

public class RandomDoubleGenerator
extends AbstractDoubleGenerator {
    public RandomDoubleGenerator() {
        this(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public RandomDoubleGenerator(double min, double max) {
        this(min, max, 0.0);
    }

    public RandomDoubleGenerator(double min, double max, double precision) {
        super(min, max, precision);
    }

    public Distribution getDistribution() {
        return Sequence.RANDOM;
    }

    public Double generate() {
        if (this.precision == 0.0) {
            return this.min + Math.random() * (this.max - this.min);
        }
        int n = (int)((this.max - this.min) / this.precision);
        return this.min + (double)SimpleRandom.randomInt(0, n) * this.precision;
    }
}

