/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import java.util.Random;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.PropertyMessage;
import org.databene.benerator.primitive.number.AbstractLongGenerator;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

public class RandomLongGenerator
extends AbstractLongGenerator {
    private static Random random = new Random();

    public RandomLongGenerator() {
    }

    public RandomLongGenerator(long min, long max) {
        super(min, max);
    }

    public RandomLongGenerator(long min, long max, long precision) {
        super(min, max, precision);
    }

    public Distribution getDistribution() {
        return Sequence.RANDOM;
    }

    public Long generate() {
        return RandomLongGenerator.generate(this.min, this.max, this.precision);
    }

    public static long generate(long min, long max, long precision) {
        if (min > max) {
            throw new InvalidGeneratorSetupException(new PropertyMessage("min", "greater than max"), new PropertyMessage("max", "less than min"));
        }
        long range = (max - min + precision) / precision;
        long result = range != 0L ? min + Math.abs(random.nextLong() % range) * precision : random.nextLong() * precision;
        if (result < min) {
            result += range;
        }
        return result;
    }
}

