/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import org.databene.benerator.primitive.number.AbstractDoubleGenerator;
import org.databene.benerator.primitive.number.distribution.RandomDoubleGenerator;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

public class RandomWalkDoubleGenerator
extends AbstractDoubleGenerator {
    private double next;
    private RandomDoubleGenerator incrementGenerator;

    public RandomWalkDoubleGenerator() {
        this(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public RandomWalkDoubleGenerator(double min, double max) {
        this(min, max, 1.0, 1.0);
    }

    public RandomWalkDoubleGenerator(double min, double max, double minIncrement, double maxIncrement) {
        super(min, max);
        this.incrementGenerator = new RandomDoubleGenerator(minIncrement, maxIncrement);
    }

    public RandomWalkDoubleGenerator(double min, double max, double precision, double minIncrement, double maxIncrement) {
        super(min, max, precision);
        this.incrementGenerator = new RandomDoubleGenerator(minIncrement, maxIncrement, precision);
    }

    public void setPrecision(double precision) {
        super.setPrecision(precision);
        this.incrementGenerator.setPrecision(precision);
    }

    public Distribution getDistribution() {
        return Sequence.RANDOM_WALK;
    }

    public double getNext() {
        return this.next;
    }

    public void setNext(double next) {
        this.next = next;
    }

    public void validate() {
        if (this.dirty) {
            this.reset();
            super.validate();
        }
    }

    public Double generate() {
        if (this.dirty) {
            this.validate();
        }
        double value = this.next;
        this.next += this.incrementGenerator.generate().doubleValue();
        if (this.next > this.max) {
            this.next = this.max;
        } else if (this.next < this.min) {
            this.next = this.min;
        }
        return value;
    }

    public void reset() {
        double minIncrement = this.incrementGenerator.getMin();
        double maxIncrement = this.incrementGenerator.getMax();
        this.next = minIncrement < 0.0 && maxIncrement <= 0.0 ? this.max : (minIncrement >= 0.0 && maxIncrement > 0.0 ? this.min : (this.min + this.max) / 2.0);
    }
}

