/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import org.databene.benerator.primitive.number.AbstractLongGenerator;
import org.databene.benerator.primitive.number.distribution.RandomLongGenerator;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

public class RandomWalkLongGenerator
extends AbstractLongGenerator {
    private long initial;
    private long next;
    private RandomLongGenerator incrementGenerator;

    public RandomWalkLongGenerator() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public RandomWalkLongGenerator(long min, long max) {
        this(min, max, 1L, 1L);
    }

    public RandomWalkLongGenerator(long min, long max, long variation1, long variation2) {
        this(min, max, 1L, variation1, variation2);
    }

    public RandomWalkLongGenerator(long min, long max, long precision, long variation1, long variation2) {
        super(min, max, precision, variation1, variation2);
        this.incrementGenerator = new RandomLongGenerator(variation1, variation2);
    }

    public Distribution getDistribution() {
        return Sequence.RANDOM_WALK;
    }

    public long getNext() {
        return this.next;
    }

    public void setNext(long next) {
        this.next = next;
    }

    public void validate() {
        if (this.dirty) {
            long minIncrement = this.variation1;
            long maxIncrement = this.variation2;
            this.incrementGenerator.setMin(minIncrement);
            this.incrementGenerator.setMax(maxIncrement);
            this.incrementGenerator.setPrecision(this.precision);
            this.initial = minIncrement < 0L && maxIncrement <= 0L ? this.max : (minIncrement >= 0L && maxIncrement > 0L ? this.min : (this.min + this.max) / 2L);
            this.next = this.initial;
            this.incrementGenerator.validate();
            super.validate();
        }
    }

    public Long generate() {
        if (this.dirty) {
            this.validate();
        }
        long value = this.next;
        this.next += this.incrementGenerator.generate().longValue();
        if (this.next > this.max) {
            this.next = this.max;
        } else if (this.next < this.min) {
            this.next = this.min;
        }
        return value;
    }

    public void reset() {
        super.reset();
        this.next = this.initial;
    }

    public void close() {
        super.close();
        this.next = this.initial;
    }
}

