/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.primitive.number.AbstractDoubleGenerator;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

public class ShuffleDoubleGenerator
extends AbstractDoubleGenerator {
    private double increment;
    private double cursor;

    public ShuffleDoubleGenerator() {
        this(Double.MIN_VALUE, Double.MAX_VALUE, 2.0, 1.0);
    }

    public ShuffleDoubleGenerator(double min, double max, double precision, double increment) {
        super(min, max, precision);
        if (precision == 0.0) {
            throw new IllegalArgumentException("Precision must be greater than zero, but is " + precision);
        }
        if (min < max && increment <= 0.0) {
            throw new IllegalArgumentException("Unsupported increment value: " + increment);
        }
        this.increment = increment;
        this.reset();
    }

    public Distribution getDistribution() {
        return Sequence.SHUFFLE;
    }

    public void setMin(Double min) {
        super.setMin(min);
        this.reset();
    }

    public double getIncrement() {
        return this.increment;
    }

    public void setIncrement(double increment) {
        this.increment = increment;
    }

    public Double generate() throws IllegalGeneratorStateException {
        double result = this.cursor;
        this.cursor = this.cursor + this.increment <= this.max ? (this.cursor += this.increment) : this.min + (this.cursor - this.min + this.precision) % this.increment;
        return result;
    }

    public void reset() {
        this.cursor = this.min;
    }
}

