/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.primitive.number.AbstractLongGenerator;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

public class ShuffleLongGenerator
extends AbstractLongGenerator {
    private long cursor;

    public ShuffleLongGenerator() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public ShuffleLongGenerator(long min, long max) {
        this(min, max, 1L);
    }

    public ShuffleLongGenerator(long min, long max, long variation1) {
        super(min, max, 1L, variation1, variation1);
        this.reset();
    }

    public Distribution getDistribution() {
        return Sequence.SHUFFLE;
    }

    public long getIncrement() {
        return this.variation1;
    }

    public void setIncrement(long increment) {
        this.variation1 = increment;
        this.dirty = true;
    }

    public void validate() {
        if (this.dirty) {
            this.cursor = this.min;
            super.validate();
            this.dirty = false;
        }
    }

    public Long generate() throws IllegalGeneratorStateException {
        if (this.dirty) {
            this.validate();
        }
        long result = this.cursor;
        long increment = this.getIncrement();
        this.cursor = this.cursor + increment <= this.max ? (this.cursor += increment) : this.min + (this.cursor - this.min + 1L) % increment;
        return result;
    }

    public void reset() {
        this.cursor = this.min;
    }
}

