/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import org.databene.benerator.primitive.number.AbstractDoubleGenerator;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

public class StepDoubleGenerator
extends AbstractDoubleGenerator {
    private double next;

    public StepDoubleGenerator() {
        this(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public StepDoubleGenerator(double min, double max) {
        this(min, max, 1.0);
    }

    public StepDoubleGenerator(double min, double max, double increment) {
        super(min, max, Math.abs(increment), increment, 0.0);
    }

    public Distribution getDistribution() {
        return Sequence.STEP;
    }

    public double getNext() {
        return this.next;
    }

    public void setNext(double next) {
        this.next = next;
    }

    public void validate() {
        if (this.dirty) {
            this.reset();
            super.validate();
        }
    }

    public Double generate() {
        if (this.dirty) {
            this.validate();
        }
        double value = this.next;
        this.next += this.variation1;
        if (this.next > this.max) {
            this.next = this.max;
        } else if (this.next < this.min) {
            this.next = this.min;
        }
        return value;
    }

    public void reset() {
        this.next = this.variation1 < 0.0 ? this.max : this.min;
    }
}

