/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.primitive.number.AbstractLongGenerator;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepLongGenerator
extends AbstractLongGenerator {
    private long next;

    public StepLongGenerator() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public StepLongGenerator(long min, long max) {
        this(min, max, 1L);
    }

    public StepLongGenerator(long min, long max, long increment) {
        super(min, max, Math.abs(increment), increment, 0L);
        this.variation1 = increment;
    }

    public Distribution getDistribution() {
        return Sequence.STEP;
    }

    public long getNext() {
        return this.next;
    }

    public void setNext(long next) {
        this.next = next;
    }

    @Override
    public void validate() {
        if (this.dirty) {
            this.reset();
            super.validate();
        }
    }

    @Override
    public Class<Long> getGeneratedType() {
        return Long.class;
    }

    @Override
    public boolean available() {
        this.validate();
        return this.variation1 == 0L || this.variation1 > 0L && this.next <= this.max || this.variation1 < 0L && this.next >= this.min;
    }

    @Override
    public Long generate() throws IllegalGeneratorStateException {
        if (!this.available()) {
            throw new IllegalGeneratorStateException("Generator " + this + " is not available. Check this by calling available() before generate()");
        }
        long value = this.next;
        this.next += this.variation1;
        return value;
    }

    @Override
    public void reset() {
        this.next = this.variation1 < 0L ? this.max : this.min;
    }

    @Override
    public void close() {
    }
}

