/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.primitive.number.AbstractLongGenerator;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

public class WedgeLongGenerator
extends AbstractLongGenerator {
    private static final Log logger = LogFactory.getLog(WedgeLongGenerator.class);
    private Long cursor;
    private long end;

    public WedgeLongGenerator() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public WedgeLongGenerator(long min, long max) {
        this(min, max, 1L);
    }

    public WedgeLongGenerator(long min, long max, long precision) {
        super(min, max, precision);
        this.cursor = min;
    }

    public Distribution getDistribution() {
        return Sequence.WEDGE;
    }

    public void validate() {
        if (this.dirty) {
            this.cursor = this.min;
            this.max = this.min + (this.max - this.min) / this.precision * this.precision;
            super.validate();
            long steps = (this.max - this.min) / this.precision + 1L;
            this.end = this.min + steps / 2L * this.precision;
            this.dirty = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("validated state: " + this.renderState()));
            }
        }
    }

    public boolean available() {
        return this.cursor != null;
    }

    public Long generate() throws IllegalGeneratorStateException {
        if (this.dirty) {
            this.validate();
        }
        if (this.cursor == null) {
            throw new IllegalGeneratorStateException("No numbers available any more");
        }
        long result = this.cursor;
        if (this.cursor == this.end) {
            this.cursor = null;
        } else {
            this.cursor = this.max - this.cursor + this.min;
            if (this.cursor < this.end) {
                this.cursor = this.cursor + this.precision;
            }
        }
        return result;
    }

    public void reset() {
        super.reset();
        this.cursor = this.min;
    }

    public void close() {
        super.close();
        this.cursor = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.renderState() + ']';
    }

    private String renderState() {
        return "min=" + this.min + ", max=" + this.max + ", precision=" + this.precision + ", cursor=" + this.cursor + ", end=" + this.end;
    }
}

