/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import java.util.Arrays;
import java.util.Random;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.primitive.number.AbstractDoubleGenerator;
import org.databene.benerator.primitive.number.distribution.ConstantFunction;
import org.databene.model.function.Distribution;
import org.databene.model.function.WeightFunction;

public class WeightedDoubleGenerator
extends AbstractDoubleGenerator {
    private WeightFunction function;
    private Random random;
    private double[] value;
    private double[] probSum;

    public WeightedDoubleGenerator() {
        this(0.0, 0.0, 1.0, new ConstantFunction(1.0));
    }

    public WeightedDoubleGenerator(double min, double max, double precision, WeightFunction function) {
        super(min, max, precision);
        if (min < max && precision <= 0.0) {
            throw new IllegalArgumentException("precision value not supported: " + precision);
        }
        this.function = function;
        this.random = new Random();
    }

    public Distribution getDistribution() {
        return this.function;
    }

    public void validate() {
        if (this.dirty) {
            int sampleCount = (int)((this.max - this.min) / this.precision) + 1;
            if (sampleCount > 100000) {
                throw new InvalidGeneratorSetupException("precision", "too small, resulting in a set of " + sampleCount + " samples");
            }
            this.probSum = new double[sampleCount];
            this.value = new double[sampleCount];
            if (sampleCount == 1) {
                this.value[0] = this.min;
                this.probSum[0] = 1.0;
            } else {
                int i;
                double sum = 0.0;
                double dx = (this.max - this.min) / (double)(sampleCount - 1);
                for (i = 0; i < sampleCount; ++i) {
                    this.value[i] = this.min + (double)i * dx;
                    this.probSum[i] = sum += this.function.value(this.value[i]);
                }
                if (sum <= 0.0) {
                    throw new IllegalGeneratorStateException("Invalid WeightFunction: Sum is not positive for " + this.function);
                }
                i = 0;
                while (i < sampleCount) {
                    int n = i++;
                    this.probSum[n] = this.probSum[n] / sum;
                }
            }
            this.dirty = false;
            super.validate();
        }
    }

    public Double generate() throws IllegalGeneratorStateException {
        if (this.dirty) {
            this.validate();
        }
        double randomValue = this.random.nextDouble();
        int n = this.intervallNoOfRandom(randomValue);
        return this.value[n];
    }

    private int intervallNoOfRandom(double random) {
        int i = Arrays.binarySearch(this.probSum, random);
        if (i < 0) {
            i = -i - 1;
        }
        if (i >= this.probSum.length) {
            return this.probSum.length - 1;
        }
        return i;
    }
}

