/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.number.distribution;

import java.util.Arrays;
import java.util.Random;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.primitive.number.AbstractLongGenerator;
import org.databene.benerator.primitive.number.distribution.ConstantFunction;
import org.databene.model.function.Distribution;
import org.databene.model.function.WeightFunction;

public class WeightedLongGenerator
extends AbstractLongGenerator {
    private WeightFunction function;
    private Random randomizer;
    private float[] probSum;

    public WeightedLongGenerator() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public WeightedLongGenerator(long min, long max) {
        this(min, max, 1L);
    }

    public WeightedLongGenerator(long min, long max, long precision) {
        this(min, max, precision, new ConstantFunction(1.0));
    }

    public WeightedLongGenerator(long min, long max, WeightFunction function) {
        this(min, max, 1L, function);
    }

    public WeightedLongGenerator(long min, long max, long precision, WeightFunction function) {
        super(min, max, 1L);
        this.function = function;
        this.precision = precision;
        this.randomizer = new Random();
        this.dirty = true;
    }

    public Distribution getDistribution() {
        return this.function;
    }

    public void setDistribution(Distribution distribution) {
        if (!(distribution instanceof WeightFunction)) {
            throw new IllegalArgumentException("Function expected, found: " + distribution);
        }
        this.function = (WeightFunction)distribution;
    }

    public void validate() {
        if (this.dirty) {
            this.normalize();
            super.validate();
            this.dirty = false;
        }
    }

    public Long generate() throws IllegalGeneratorStateException {
        if (this.dirty) {
            this.validate();
        }
        float random = this.randomizer.nextFloat();
        long n = this.intervallNoOfRandom(random);
        return this.min + n * this.precision;
    }

    private long intervallNoOfRandom(float random) {
        int i = Arrays.binarySearch(this.probSum, random);
        if (i < 0) {
            i = -i - 1;
        }
        if (i >= this.probSum.length) {
            return this.probSum.length - 1;
        }
        return i;
    }

    private void normalize() {
        int sampleCount = (int)((this.max - this.min) / this.precision) + 1;
        if (sampleCount > 100000) {
            throw new InvalidGeneratorSetupException("precision", "too small, resulting in a set of " + sampleCount + " samples");
        }
        this.probSum = new float[sampleCount];
        if (sampleCount == 1) {
            this.probSum[0] = 1.0f;
        } else {
            double sum = 0.0;
            for (int i = 0; i < sampleCount; ++i) {
                long dx = (this.max - this.min) / (long)(sampleCount - 1);
                long x = this.min + (long)i * dx;
                this.probSum[i] = (float)(sum += this.function.value(x));
            }
            if (sum == 0.0) {
                float avgProp = 1.0f / (float)sampleCount;
                for (int i = 0; i < sampleCount; ++i) {
                    this.probSum[i] = (float)(i + 1) * avgProp;
                }
            } else if (sum < 0.0) {
                throw new IllegalGeneratorStateException("Invalid WeightFunction: Sum is negative (" + sum + ") for " + this.function);
            }
            int i = 0;
            while (i < sampleCount) {
                int n = i++;
                this.probSum[n] = this.probSum[n] / (float)sum;
            }
        }
    }
}

